/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.compaction.CompactionPolicy;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;
import java.io.IOException;

public class SizeBasedCompactionPolicy
implements CompactionPolicy {
    private final IOManager ioManager;
    private final ObjectManager<?, ?, ?> objectManager;
    private final double sizeThreshold;
    private final double compactionPercentage;
    private boolean isCompacting;
    private long entriesToCompact;

    public SizeBasedCompactionPolicy(IOManager ioManager, ObjectManager<?, ?, ?> objectManager, Configuration configuration) {
        this.ioManager = ioManager;
        this.objectManager = objectManager;
        this.sizeThreshold = configuration.getDouble(FrsProperty.COMPACTOR_SIZEBASED_THRESHOLD);
        this.compactionPercentage = configuration.getDouble(FrsProperty.COMPACTOR_SIZEBASED_AMOUNT);
    }

    @Override
    public boolean startCompacting() {
        float ratio;
        try {
            ratio = this.objectManager.sizeInBytes() / this.ioManager.getStatistics().getLiveSize();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get log size.", e);
        }
        if ((double)ratio <= this.sizeThreshold) {
            this.isCompacting = true;
            this.entriesToCompact = (long)((double)this.objectManager.size() * this.compactionPercentage);
            return true;
        }
        return false;
    }

    @Override
    public boolean compacted(ObjectManagerEntry<?, ?, ?> entry) {
        if (!this.isCompacting) {
            throw new AssertionError((Object)"Compaction is not started.");
        }
        return this.entriesToCompact-- > 0L;
    }

    @Override
    public void stoppedCompacting() {
        if (!this.isCompacting) {
            throw new AssertionError((Object)"Compaction is not started.");
        }
        this.isCompacting = false;
    }
}

