/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.user.dao.impl;

import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.security.shiro.ShiroIniFileConstants;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserRole;
import com.terracotta.management.user.dao.DatastoreNotFoundException;
import com.terracotta.management.user.dao.UserInfoDao;
import com.terracotta.management.user.dao.impl.IniFileUserInfoDao;
import com.terracotta.management.user.impl.DfltUserInfo;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class IniFileUserInfoDao
implements UserInfoDao {
    private static final String USR_HEADER = "[users]";
    private static final Pattern INVALID_USRNAME_CHARS = Pattern.compile("[=]");
    private static final Logger LOG = LoggerFactory.getLogger(IniFileUserInfoDao.class);
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final File iniFile;

    public IniFileUserInfoDao() throws DataAccessException {
        this(new File(System.getProperty("com.tc.management.security.ini") == null ? ShiroIniFileConstants.DFLT_INI_FILE_LOCATION : System.getProperty("com.tc.management.security.ini")));
    }

    public IniFileUserInfoDao(File iniFile) throws DataAccessException {
        this(iniFile, true);
    }

    public IniFileUserInfoDao(File iniFile, boolean createFile) throws DataAccessException {
        this.iniFile = iniFile;
        if (createFile && !this.iniFile.exists()) {
            this.initIniFile();
        }
    }

    public UserInfo getById(String username) throws DataAccessException {
        AtomicReference<Object> usrRef = new AtomicReference<Object>(null);
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        task.execute();
        return usrRef.get();
    }

    public synchronized void create(UserInfo user) throws DataAccessException {
        2 task = new /* Unavailable Anonymous Inner Class!! */;
        task.execute();
    }

    public void createOrUpdate(UserInfo user) throws DataAccessException {
        3 task = new /* Unavailable Anonymous Inner Class!! */;
        task.execute();
    }

    public void delete(UserInfo user) throws DataAccessException {
        4 task = new /* Unavailable Anonymous Inner Class!! */;
        task.execute();
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public void evict(UserInfo user) {
        throw new UnsupportedOperationException();
    }

    public boolean hasUserInfos() throws DataAccessException {
        AtomicBoolean available = new AtomicBoolean(false);
        5 task = new /* Unavailable Anonymous Inner Class!! */;
        task.execute();
        return available.get();
    }

    public void truncate() throws DataAccessException {
        6 task = new /* Unavailable Anonymous Inner Class!! */;
        task.execute();
    }

    public synchronized void validate(boolean establish) throws DataAccessException {
        if (!this.iniFile.exists()) {
            if (establish) {
                this.initIniFile();
            } else {
                throw new DatastoreNotFoundException();
            }
        }
    }

    private static String buildNewUserLine(UserInfo userInfo) throws DataAccessException {
        Matcher m = INVALID_USRNAME_CHARS.matcher(userInfo.getUsername());
        if (m.find()) {
            throw new DataAccessException(String.format("Invalid username '%s' detected! Unable to update datastore.", userInfo.getUsername()));
        }
        StringBuilder sb = new StringBuilder(userInfo.getUsername());
        sb.append("=").append(userInfo.getPasswordHash());
        Set roles = userInfo.getRoles();
        if (roles != null) {
            Iterator rItr = roles.iterator();
            do {
                sb.append(",").append(((UserRole)rItr.next()).toString());
            } while (rItr.hasNext());
        }
        sb.append(LINE_SEP);
        return sb.toString();
    }

    private static UserInfo buildUserInfo(String iniEntry) {
        String[] components = iniEntry.split(",");
        String[] credentials = components[0].split("=", 2);
        HashSet<UserRole> roles = null;
        for (int i = 1; i < components.length; ++i) {
            if (roles == null) {
                roles = new HashSet<UserRole>();
            }
            roles.add(UserRole.byName((String)IniFileUserInfoDao.trimToNull((String)components[i])));
        }
        return new DfltUserInfo(IniFileUserInfoDao.trimToNull((String)credentials[0]), IniFileUserInfoDao.trimToNull((String)credentials[1]), roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIniFile() throws DataAccessException {
        File parent = this.iniFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            File temp = File.createTempFile("tmp", UUID.randomUUID().toString(), parent);
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(temp, true));
                try {
                    writer.write("[users]" + LINE_SEP);
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close FileWriter creating new security ini file.");
                    }
                }
                if (!this.iniFile.exists()) {
                    temp.renameTo(this.iniFile);
                } else {
                    temp.delete();
                }
            }
            catch (IOException e) {
                if (temp.exists()) {
                    temp.delete();
                }
                throw new DataAccessException(String.format("Failure writing new security ini file.", new Object[0]), (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new DataAccessException("Failed to create ini file.", (Throwable)e);
        }
    }

    private void update(FileChannel fc, UserInfo user, boolean replace) throws IOException, DataAccessException {
        long cSize = fc.size();
        ByteBuffer mbb = ByteBuffer.allocate((int)cSize);
        fc.read(mbb);
        mbb.flip();
        int p = this.findUserPosition(user.getUsername(), mbb);
        mbb.position(p == -1 ? 0 : p);
        UserInfo thisUser = null;
        if (p > -1) {
            byte b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = mbb.get()) != LINE_SEP.charAt(0)) {
                baos.write(b);
            }
            thisUser = IniFileUserInfoDao.buildUserInfo((String)new String(baos.toByteArray()));
        }
        byte[] tail = null;
        if (replace || user.equals(thisUser)) {
            if (p > -1) {
                int end = mbb.position();
                tail = new byte[(int)cSize - end];
                mbb.get(tail);
                fc.truncate(p);
                fc.position(fc.size());
            } else {
                fc.position(cSize);
            }
            if (replace) {
                ByteBuffer bbReplace = ByteBuffer.wrap(IniFileUserInfoDao.buildNewUserLine((UserInfo)user).getBytes());
                while (bbReplace.hasRemaining()) {
                    fc.write(bbReplace);
                }
            }
            if (tail != null) {
                ByteBuffer bbTail = ByteBuffer.wrap(tail);
                while (bbTail.hasRemaining()) {
                    fc.write(bbTail);
                }
            }
        }
    }

    private int findUserPosition(String username, ByteBuffer buffer) throws IOException {
        int pos = -1;
        byte[] matchMe = (username + "=").getBytes();
        byte[] forMatch = null;
        int count = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == LINE_SEP.charAt(0)) {
                forMatch = new byte[matchMe.length];
                int lsl = LINE_SEP.length();
                if (lsl <= 1) continue;
                while (lsl > 1) {
                    buffer.get();
                    --lsl;
                }
                continue;
            }
            if (count == matchMe.length) {
                if (Arrays.equals(matchMe, forMatch)) {
                    pos = buffer.position() - matchMe.length - 1;
                    break;
                }
                forMatch = null;
                count = 0;
                continue;
            }
            if (forMatch == null) continue;
            forMatch[count++] = b;
        }
        return pos;
    }

    private static String trimToNull(String string) {
        return string == null || string.trim().length() == 0 ? null : string.trim();
    }

    static /* synthetic */ int access$100(IniFileUserInfoDao x0, String x1, ByteBuffer x2) throws IOException {
        return x0.findUserPosition(x1, x2);
    }

    static /* synthetic */ String access$200() {
        return LINE_SEP;
    }

    static /* synthetic */ UserInfo access$300(String x0) {
        return IniFileUserInfoDao.buildUserInfo((String)x0);
    }

    static /* synthetic */ String access$400(UserInfo x0) throws DataAccessException {
        return IniFileUserInfoDao.buildNewUserLine((UserInfo)x0);
    }

    static /* synthetic */ void access$500(IniFileUserInfoDao x0, FileChannel x1, UserInfo x2, boolean x3) throws IOException, DataAccessException {
        x0.update(x1, x2, x3);
    }

    static /* synthetic */ File access$600(IniFileUserInfoDao x0) {
        return x0.iniFile;
    }
}

