/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.impl;

import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.URIKeyName;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.SSLContextFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.terracotta.management.resource.services.Utils;

public final class DfltSSLContextFactory
implements SSLContextFactory {
    private static final String JVM_ID_LOCATION_PROP = "javax.net.ssl.keyStore";
    private static final String JVM_ID_PASSWD_PROP = "javax.net.ssl.keyStorePassword";
    private static final String JVM_TRUST_LOCATION_PROP = "javax.net.ssl.trustStore";
    private static final String JVM_TRUST_PASSWD_PROP = "javax.net.ssl.trustStorePassword";
    private static final String SS_PROTOCOL = "TLS";
    private static final String FILE_URI_PREFIX = "file://";
    private static final String SECURE_RNDM_ALG = "SHA1PRNG";
    private final KeyChainAccessor keyChainAccessor;
    private final String idStoreLocation;
    private final String trustStoreLocation;
    private final boolean usingClientAuth;

    public DfltSSLContextFactory(KeyChainAccessor keyChainAccessor, String dfltIdStoreLocation, String dfltTrustStoreLocation) {
        this(keyChainAccessor, dfltIdStoreLocation, dfltTrustStoreLocation, false);
    }

    public DfltSSLContextFactory(KeyChainAccessor keyChainAccessor, String dfltIdStoreLocation, String dfltTrustStoreLocation, boolean usingClientAuth) {
        this.keyChainAccessor = keyChainAccessor;
        this.idStoreLocation = System.getProperty(JVM_ID_LOCATION_PROP) == null ? dfltIdStoreLocation : System.getProperty(JVM_ID_LOCATION_PROP);
        this.trustStoreLocation = System.getProperty(JVM_TRUST_LOCATION_PROP) == null ? dfltTrustStoreLocation : System.getProperty(JVM_TRUST_LOCATION_PROP);
        this.usingClientAuth = usingClientAuth;
    }

    public SSLContext create() throws NoSuchAlgorithmException, IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        SSLContext sslCtxt = null;
        KeyManagerFactory kmf = this.prepareKeyManagerFactory();
        TrustManagerFactory tmf = this.prepareTrustManagerFactory();
        if (kmf != null || tmf != null) {
            sslCtxt = SSLContext.getInstance(SS_PROTOCOL);
            sslCtxt.init(kmf == null ? null : kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), SecureRandom.getInstance(SECURE_RNDM_ALG));
        }
        return sslCtxt;
    }

    public boolean isUsingClientAuth() {
        return this.usingClientAuth;
    }

    private KeyManagerFactory prepareKeyManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, URISyntaxException {
        KeyManagerFactory kmf = null;
        File idStoreFile = new File(this.idStoreLocation);
        if (idStoreFile.exists()) {
            char[] idStorePasswd = this.locateKeyStorePassword(JVM_ID_PASSWD_PROP, this.idStoreLocation);
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
            identityStore.load(new FileInputStream(idStoreFile), idStorePasswd);
            kmf.init(identityStore, idStorePasswd);
        }
        return kmf;
    }

    private TrustManagerFactory prepareTrustManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, URISyntaxException {
        TrustManagerFactory tmf = null;
        File trustStoreFile = new File(this.trustStoreLocation);
        if (trustStoreFile.exists()) {
            char[] trustStorePasswd = this.locateKeyStorePassword(JVM_TRUST_PASSWD_PROP, this.trustStoreLocation);
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(new FileInputStream(trustStoreFile), trustStorePasswd);
            tmf.init(trustStore);
        }
        return tmf;
    }

    private char[] locateKeyStorePassword(String jvmPasswordProp, String keyStoreLocation) throws URISyntaxException {
        char[] passwd;
        String jvmStorePasswd = System.getProperty(jvmPasswordProp);
        if (Utils.trimToNull((String)jvmStorePasswd) == null) {
            URI idStoreURI = new URI(FILE_URI_PREFIX + keyStoreLocation);
            URIKeyName kname = new URIKeyName(idStoreURI);
            byte[] secret = this.keyChainAccessor.retrieveSecret((KeyName)kname);
            if (secret == null) {
                throw new RuntimeException(String.format("Failure creating SSLContext because the store password could not be located for %s.", keyStoreLocation));
            }
            passwd = this.toChar(secret);
            Arrays.fill(secret, (byte)0);
        } else {
            passwd = jvmStorePasswd.toCharArray();
        }
        return passwd;
    }

    private char[] toChar(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return chars;
    }
}

