/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import com.terracotta.management.security.SecretProvider;
import com.terracotta.management.security.SecretProviderBackEnd;
import java.util.concurrent.atomic.AtomicReference;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecretProvider {
    private static final AtomicReference<SecretProviderBackEnd> backEnd = new AtomicReference();
    public static final String CUSTOM_IMPL_PROP = "com.tc.SecretProvider.impl";

    public static byte[] getSecret() {
        return SecretProvider.getBackEnd().getSecret();
    }

    public static void fetchSecret() {
        SecretProviderBackEnd secretProviderBackEnd = (SecretProviderBackEnd)backEnd.get();
        if (secretProviderBackEnd == null) {
            String implClass = System.getProperty("com.tc.SecretProvider.impl");
            if (implClass != null) {
                try {
                    Class<?> clazz = Class.forName(implClass);
                    secretProviderBackEnd = (SecretProviderBackEnd)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Couldn't load class '" + implClass + "'", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't instantiate SecretProvider's backing implementation '" + implClass + "'", e);
                }
            } else {
                secretProviderBackEnd = new ConsoleFetchingBackEnd(null);
            }
            backEnd.compareAndSet(null, secretProviderBackEnd);
        }
        SecretProvider.getBackEnd().fetchSecret();
    }

    public static boolean fetchSecret(SecretProviderBackEnd back) {
        boolean installed = backEnd.compareAndSet(null, back);
        if (installed) {
            SecretProvider.getBackEnd().fetchSecret();
        }
        return installed;
    }

    static SecretProviderBackEnd getBackEnd() {
        return (SecretProviderBackEnd)backEnd.get();
    }
}

