/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.util.QNameMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class QNameMap<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    transient Entry<V>[] table = new Entry[16];
    transient int size;
    private int threshold = 12;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Set<Entry<V>> entrySet = null;

    public void put(String namespaceUri, String localname, V value) {
        assert (localname != null);
        assert (namespaceUri != null);
        assert (localname == localname.intern());
        assert (namespaceUri == namespaceUri.intern());
        int hash = QNameMap.hash((String)localname);
        int i = QNameMap.indexFor((int)hash, (int)this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && localname == e.localName && namespaceUri == e.nsUri) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.addEntry(hash, namespaceUri, localname, value, i);
    }

    public void put(QName name, V value) {
        this.put(name.getNamespaceURI(), name.getLocalPart(), value);
    }

    public void put(Name name, V value) {
        this.put(name.nsUri, name.localName, value);
    }

    public V get(String nsUri, String localPart) {
        Entry e = this.getEntry(nsUri, localPart);
        if (e == null) {
            return null;
        }
        return (V)e.value;
    }

    public V get(QName name) {
        return (V)this.get(name.getNamespaceURI(), name.getLocalPart());
    }

    public int size() {
        return this.size;
    }

    public QNameMap<V> putAll(QNameMap<? extends V> map) {
        int numKeysToBeAdded = map.size();
        if (numKeysToBeAdded == 0) {
            return this;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = numKeysToBeAdded;
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Entry e : map.entrySet()) {
            this.put(e.nsUri, e.localName, e.getValue());
        }
        return this;
    }

    private static int hash(String x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private void addEntry(int hash, String nsUri, String localName, V value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, nsUri, localName, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = newCapacity;
    }

    private void transfer(Entry<V>[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = QNameMap.indexFor((int)e.hash, (int)newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public Entry<V> getOne() {
        for (Entry e : this.table) {
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public Collection<QName> keySet() {
        HashSet<QName> r = new HashSet<QName>();
        for (Entry e : this.entrySet()) {
            r.add(e.createQName());
        }
        return r;
    }

    public boolean containsKey(String nsUri, String localName) {
        return this.getEntry(nsUri, localName) != null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set<Entry<V>> entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this, null));
    }

    private Iterator<Entry<V>> newEntryIterator() {
        return new EntryIterator(this, null);
    }

    private Entry<V> getEntry(String nsUri, String localName) {
        assert (nsUri == nsUri.intern());
        assert (localName == localName.intern());
        int hash = QNameMap.hash((String)localName);
        int i = QNameMap.indexFor((int)hash, (int)this.table.length);
        Entry e = this.table[i];
        while (e != null && (localName != e.localName || nsUri != e.nsUri)) {
            e = e.next;
        }
        return e;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        for (Entry e : this.entrySet()) {
            if (buf.length() > 1) {
                buf.append(',');
            }
            buf.append('[');
            buf.append(e);
            buf.append(']');
        }
        buf.append('}');
        return buf.toString();
    }

    static /* synthetic */ Iterator access$200(QNameMap x0) {
        return x0.newEntryIterator();
    }

    static /* synthetic */ Entry access$300(QNameMap x0, String x1, String x2) {
        return x0.getEntry(x1, x2);
    }
}

