/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.service;

import com.sun.jersey.impl.SpiMessages;
import com.sun.jersey.spi.service.ServiceConfigurationError;
import com.sun.jersey.spi.service.ServiceFinder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ServiceFinder<T>
implements Iterable<T> {
    private static final Logger LOGGER = Logger.getLogger(ServiceFinder.class.getName());
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String MODULE_VERSION = "META-INF/jersey-module-version";
    private static final String PREFIX = "META-INF/services/";
    private static final String BUNDLE_VERSION_ATTRIBUTE = "Bundle-Version";
    private static final String BUNDLE_SYMBOLIC_NAME_ATTRIBUTE = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = ServiceFinder.getBundleAttribute((String)"Bundle-Version");
    private static final String BUNDLE_SYMBOLIC_NAME = ServiceFinder.getBundleAttribute((String)"Bundle-SymbolicName");
    private static final String MODULE_VERSION_VALUE = ServiceFinder.getModuleVersion();
    private final Class<T> serviceClass;
    private final String serviceName;
    private final ClassLoader classLoader;
    private final boolean ignoreOnClassNotFound;
    private static final Map<URL, Boolean> manifestURLs = new HashMap();

    private static String getBundleAttribute(String attributeName) {
        try {
            String version = ServiceFinder.getManifest(ServiceFinder.class).getMainAttributes().getValue(attributeName);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ServiceFinder " + attributeName + ": " + version);
            }
            return version;
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Error loading META-INF/MANIFEST.MF associated with " + ServiceFinder.class.getName(), ex);
            return null;
        }
    }

    private static String getModuleVersion() {
        try {
            String resource = ServiceFinder.class.getName().replace(".", "/") + ".class";
            URL url = ServiceFinder.getResource((ClassLoader)ServiceFinder.class.getClassLoader(), (String)resource);
            if (url == null) {
                LOGGER.log(Level.FINE, "Error getting " + ServiceFinder.class.getName() + " class as a resource");
                return null;
            }
            return ServiceFinder.getJerseyModuleVersion((URL)ServiceFinder.getManifestURL((String)resource, (URL)url));
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Error loading META-INF/jersey-module-version associated with " + ServiceFinder.class.getName(), ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Enumeration<URL> filterServiceURLsWithVersion(String serviceName, Enumeration<URL> serviceUrls) {
        if (BUNDLE_VERSION == null || !serviceUrls.hasMoreElements()) {
            return serviceUrls;
        }
        ArrayList<URL> urls = Collections.list(serviceUrls);
        ListIterator li = urls.listIterator();
        while (li.hasNext()) {
            URL url = (URL)li.next();
            try {
                URL manifestURL = ServiceFinder.getManifestURL((String)serviceName, (URL)url);
                Map map = manifestURLs;
                synchronized (map) {
                    Boolean keep = (Boolean)manifestURLs.get(manifestURL);
                    if (keep != null) {
                        if (!keep.booleanValue()) {
                            if (LOGGER.isLoggable(Level.CONFIG)) {
                                LOGGER.config("Ignoring service URL: " + url);
                            }
                            li.remove();
                        } else if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Including service URL: " + url);
                        }
                    } else if (!ServiceFinder.compatibleManifest((URL)manifestURL)) {
                        if (LOGGER.isLoggable(Level.CONFIG)) {
                            LOGGER.config("Ignoring service URL: " + url);
                        }
                        li.remove();
                        manifestURLs.put(manifestURL, false);
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Including service URL: " + url);
                        }
                        manifestURLs.put(manifestURL, true);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Error loading META-INF/MANIFEST.MF associated with " + url, ex);
            }
        }
        return Collections.enumeration(urls);
    }

    private static boolean compatibleManifest(URL manifestURL) throws IOException {
        Attributes as = ServiceFinder.getManifest((URL)manifestURL).getMainAttributes();
        String symbolicName = as.getValue("Bundle-SymbolicName");
        String version = as.getValue("Bundle-Version");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Checking META-INF/MANIFEST.MF URL: " + manifestURL + "\n  " + "Bundle-SymbolicName" + ": " + symbolicName + "\n  " + "Bundle-Version" + ": " + version);
        }
        if (symbolicName != null && symbolicName.startsWith("com.sun.jersey") && !BUNDLE_VERSION.equals(version)) {
            return false;
        }
        String moduleVersion = ServiceFinder.getJerseyModuleVersion((URL)manifestURL);
        return moduleVersion == null || moduleVersion.equals(MODULE_VERSION_VALUE) && (symbolicName == null || !(BUNDLE_SYMBOLIC_NAME.startsWith("com.sun.jersey") ^ symbolicName.startsWith("com.sun.jersey")));
    }

    private static String getJerseyModuleVersion(URL manifestURL) {
        try {
            URL moduleVersionURL = new URL(manifestURL.toString().replace("META-INF/MANIFEST.MF", "META-INF/jersey-module-version"));
            return new BufferedReader(new InputStreamReader(moduleVersionURL.openStream())).readLine();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Error loading META-INF/jersey-module-version associated with " + ServiceFinder.class.getName(), ioe);
            return null;
        }
    }

    private static Manifest getManifest(Class c) throws IOException {
        String resource = c.getName().replace(".", "/") + ".class";
        URL url = ServiceFinder.getResource((ClassLoader)c.getClassLoader(), (String)resource);
        if (url == null) {
            throw new IOException("Resource not found: " + url);
        }
        return ServiceFinder.getManifest((String)resource, (URL)url);
    }

    private static Manifest getManifest(String name, URL serviceURL) throws IOException {
        return ServiceFinder.getManifest((URL)ServiceFinder.getManifestURL((String)name, (URL)serviceURL));
    }

    private static URL getManifestURL(String name, URL serviceURL) throws IOException {
        return new URL(serviceURL.toString().replace(name, "META-INF/MANIFEST.MF"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            Manifest manifest = new Manifest(in);
            return manifest;
        }
        finally {
            in.close();
        }
    }

    private static URL getResource(ClassLoader loader, String name) throws IOException {
        if (loader == null) {
            return ServiceFinder.getResource((String)name);
        }
        URL resource = loader.getResource(name);
        if (resource != null) {
            return resource;
        }
        return ServiceFinder.getResource((String)name);
    }

    private static URL getResource(String name) throws IOException {
        if (ServiceFinder.class.getClassLoader() != null) {
            return ServiceFinder.class.getClassLoader().getResource(name);
        }
        return ClassLoader.getSystemResource(name);
    }

    private static Enumeration<URL> getResources(ClassLoader loader, String name) throws IOException {
        if (loader == null) {
            return ServiceFinder.getResources((String)name);
        }
        Enumeration<URL> resources = loader.getResources(name);
        if (resources.hasMoreElements()) {
            return resources;
        }
        return ServiceFinder.getResources((String)name);
    }

    private static Enumeration<URL> getResources(String name) throws IOException {
        if (ServiceFinder.class.getClassLoader() != null) {
            return ServiceFinder.class.getClassLoader().getResources(name);
        }
        return ClassLoader.getSystemResources(name);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, ClassLoader loader) throws ServiceConfigurationError {
        return ServiceFinder.find(service, (ClassLoader)loader, (boolean)false);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound) throws ServiceConfigurationError {
        return new ServiceFinder(service, loader, ignoreOnClassNotFound);
    }

    public static <T> ServiceFinder<T> find(Class<T> service) throws ServiceConfigurationError {
        return ServiceFinder.find(service, (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)false);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, boolean ignoreOnClassNotFound) throws ServiceConfigurationError {
        return ServiceFinder.find(service, (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)ignoreOnClassNotFound);
    }

    public static ServiceFinder<?> find(String serviceName) throws ServiceConfigurationError {
        return new ServiceFinder(Object.class, serviceName, Thread.currentThread().getContextClassLoader(), false);
    }

    public static void setIteratorProvider(ServiceIteratorProvider sip) throws SecurityException {
        ServiceIteratorProvider.access$000((ServiceIteratorProvider)sip);
    }

    private ServiceFinder(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound) {
        this(service, service.getName(), loader, ignoreOnClassNotFound);
    }

    private ServiceFinder(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
        this.serviceClass = service;
        this.serviceName = serviceName;
        this.classLoader = loader;
        this.ignoreOnClassNotFound = ignoreOnClassNotFound;
    }

    @Override
    public Iterator<T> iterator() {
        return ServiceIteratorProvider.access$100().createIterator(this.serviceClass, this.serviceName, this.classLoader, this.ignoreOnClassNotFound);
    }

    private Iterator<Class<T>> classIterator() {
        return ServiceIteratorProvider.access$100().createClassIterator(this.serviceClass, this.serviceName, this.classLoader, this.ignoreOnClassNotFound);
    }

    public T[] toArray() throws ServiceConfigurationError {
        ArrayList result = new ArrayList();
        for (Object t : this) {
            result.add(t);
        }
        return result.toArray((Object[])Array.newInstance(this.serviceClass, result.size()));
    }

    public Class<T>[] toClassArray() throws ServiceConfigurationError {
        ArrayList result = new ArrayList();
        Iterator i = this.classIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result.toArray((Class[])Array.newInstance(Class.class, result.size()));
    }

    private static void fail(String serviceName, String msg, Throwable cause) throws ServiceConfigurationError {
        ServiceConfigurationError sce = new ServiceConfigurationError(serviceName + ": " + msg);
        sce.initCause(cause);
        throw sce;
    }

    private static void fail(String serviceName, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(serviceName + ": " + msg);
    }

    private static void fail(String serviceName, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceFinder.fail((String)serviceName, (String)(u + ":" + line + ": " + msg));
    }

    private static int parseLine(String serviceName, URL u, BufferedReader r, int lc, List<String> names, Set<String> returned) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceFinder.fail((String)serviceName, (URL)u, (int)lc, (String)SpiMessages.ILLEGAL_CONFIG_SYNTAX());
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceFinder.fail((String)serviceName, (URL)u, (int)lc, (String)SpiMessages.ILLEGAL_PROVIDER_CLASS_NAME((Object)ln));
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceFinder.fail((String)serviceName, (URL)u, (int)lc, (String)SpiMessages.ILLEGAL_PROVIDER_CLASS_NAME((Object)ln));
            }
            if (!returned.contains(ln)) {
                names.add(ln);
                returned.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(String serviceName, URL u, Set<String> returned) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList names = new ArrayList();
        try {
            URLConnection uConn = u.openConnection();
            uConn.setUseCaches(false);
            in = uConn.getInputStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = ServiceFinder.parseLine((String)serviceName, (URL)u, (BufferedReader)r, (int)lc, names, returned)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceFinder.fail((String)serviceName, (String)(": " + x));
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceFinder.fail((String)serviceName, (String)(": " + y));
            }
        }
        return names.iterator();
    }

    static /* synthetic */ Enumeration access$200(ClassLoader x0, String x1) throws IOException {
        return ServiceFinder.getResources((ClassLoader)x0, (String)x1);
    }

    static /* synthetic */ Enumeration access$300(String x0, Enumeration x1) {
        return ServiceFinder.filterServiceURLsWithVersion((String)x0, (Enumeration)x1);
    }

    static /* synthetic */ void access$400(String x0, String x1) throws ServiceConfigurationError {
        ServiceFinder.fail((String)x0, (String)x1);
    }

    static /* synthetic */ Iterator access$500(String x0, URL x1, Set x2) throws ServiceConfigurationError {
        return ServiceFinder.parse((String)x0, (URL)x1, (Set)x2);
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }

    static /* synthetic */ void access$800(String x0, String x1, Throwable x2) throws ServiceConfigurationError {
        ServiceFinder.fail((String)x0, (String)x1, (Throwable)x2);
    }
}

