/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.scanning.servlet;

import com.sun.jersey.core.spi.scanning.Scanner;
import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.core.util.Closing;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletContext;

public class WebAppResourcesScanner
implements Scanner {
    private final String[] paths;
    private final ServletContext sc;

    public WebAppResourcesScanner(String[] paths, ServletContext sc) {
        this.paths = paths;
        this.sc = sc;
    }

    public void scan(ScannerListener cfl) {
        for (String path : this.paths) {
            this.scan(path, cfl);
        }
    }

    private void scan(String root, ScannerListener cfl) {
        Set resourcePaths = this.sc.getResourcePaths(root);
        if (resourcePaths == null) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith("/")) {
                this.scan(resourcePath, cfl);
                continue;
            }
            if (resourcePath.endsWith(".jar")) {
                try {
                    new Closing(this.sc.getResourceAsStream(resourcePath)).f((Closing.Closure)new /* Unavailable Anonymous Inner Class!! */);
                    continue;
                }
                catch (IOException ex) {
                    throw new ScannerException("IO error scanning jar " + resourcePath, (Throwable)ex);
                }
            }
            if (!cfl.onAccept(resourcePath)) continue;
            try {
                new Closing(this.sc.getResourceAsStream(resourcePath)).f((Closing.Closure)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException ex) {
                throw new ScannerException("IO error scanning resource " + resourcePath, (Throwable)ex);
            }
        }
    }
}

