/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.scanning;

import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.spi.scanning.AnnotationScannerListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AnnotationScannerListener
implements ScannerListener {
    private final ClassLoader classloader;
    private final Set<Class<?>> classes;
    private final Set<String> annotations;
    private final AnnotatedClassVisitor classVisitor;

    public AnnotationScannerListener(Class<? extends Annotation> ... annotations) {
        this(ReflectionHelper.getContextClassLoader(), (Class[])annotations);
    }

    public AnnotationScannerListener(ClassLoader classloader, Class<? extends Annotation> ... annotations) {
        this.classloader = classloader;
        this.classes = new LinkedHashSet();
        this.annotations = this.getAnnotationSet((Class[])annotations);
        this.classVisitor = new AnnotatedClassVisitor(this, null);
    }

    public Set<Class<?>> getAnnotatedClasses() {
        return this.classes;
    }

    private Set<String> getAnnotationSet(Class<? extends Annotation> ... annotations) {
        HashSet<String> a = new HashSet<String>();
        for (Class<? extends Annotation> c : annotations) {
            a.add("L" + c.getName().replaceAll("\\.", "/") + ";");
        }
        return a;
    }

    public boolean onAccept(String name) {
        return name.endsWith(".class");
    }

    public void onProcess(String name, InputStream in) throws IOException {
        new ClassReader(in).accept((ClassVisitor)this.classVisitor, 0);
    }

    static /* synthetic */ Set access$100(AnnotationScannerListener x0) {
        return x0.annotations;
    }

    static /* synthetic */ Set access$200(AnnotationScannerListener x0) {
        return x0.classes;
    }

    static /* synthetic */ ClassLoader access$300(AnnotationScannerListener x0) {
        return x0.classloader;
    }
}

