/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.uri.rules;

import com.sun.jersey.server.impl.uri.rules.AtomicMatchingPatterns;
import com.sun.jersey.server.impl.uri.rules.PatternRulePair;
import com.sun.jersey.spi.uri.rules.UriMatchResultContext;
import com.sun.jersey.spi.uri.rules.UriRules;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.MatchResult;

public final class AtomicMatchingPatterns<R>
implements UriRules<R> {
    private final Collection<PatternRulePair<R>> rules;

    public AtomicMatchingPatterns(Collection<PatternRulePair<R>> rules) {
        this.rules = rules;
    }

    public Iterator<R> match(CharSequence path, UriMatchResultContext resultContext) {
        if (resultContext.isTracingEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("match path \"").append(path).append("\" -> ");
            boolean first = true;
            for (PatternRulePair prp : this.rules) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append("\"").append(prp.p.toString()).append("\"");
                first = false;
            }
            resultContext.trace(sb.toString());
        }
        for (PatternRulePair prp : this.rules) {
            MatchResult mr = prp.p.match(path);
            if (mr == null) continue;
            resultContext.setMatchResult(mr);
            return new SingleEntryIterator(prp.r);
        }
        return new EmptyIterator(null);
    }
}

