/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.monitoring;

import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.server.impl.monitoring.MonitoringProviderFactory;
import com.sun.jersey.spi.monitoring.DispatchingListener;
import com.sun.jersey.spi.monitoring.DispatchingListenerAdapter;
import com.sun.jersey.spi.monitoring.RequestListener;
import com.sun.jersey.spi.monitoring.RequestListenerAdapter;
import com.sun.jersey.spi.monitoring.ResponseListener;
import com.sun.jersey.spi.monitoring.ResponseListenerAdapter;
import java.util.Set;

public final class MonitoringProviderFactory {
    private static final EmptyListener EMPTY_LISTENER = new EmptyListener(null);

    private MonitoringProviderFactory() {
    }

    public static RequestListener createRequestListener(ProviderServices providerServices) {
        Set listeners = providerServices.getProvidersAndServices(RequestListener.class);
        EmptyListener requestListener = listeners.isEmpty() ? EMPTY_LISTENER : new AggregatedRequestListener(listeners, null);
        for (RequestListenerAdapter a : providerServices.getProvidersAndServices(RequestListenerAdapter.class)) {
            requestListener = a.adapt((RequestListener)requestListener);
        }
        return requestListener;
    }

    public static DispatchingListener createDispatchingListener(ProviderServices providerServices) {
        Set listeners = providerServices.getProvidersAndServices(DispatchingListener.class);
        EmptyListener dispatchingListener = listeners.isEmpty() ? EMPTY_LISTENER : new AggregatedDispatchingListener(listeners, null);
        for (DispatchingListenerAdapter a : providerServices.getProvidersAndServices(DispatchingListenerAdapter.class)) {
            dispatchingListener = a.adapt((DispatchingListener)dispatchingListener);
        }
        return dispatchingListener;
    }

    public static ResponseListener createResponseListener(ProviderServices providerServices) {
        Set listeners = providerServices.getProvidersAndServices(ResponseListener.class);
        EmptyListener responseListener = listeners.isEmpty() ? EMPTY_LISTENER : new AggregatedResponseListener(listeners, null);
        for (ResponseListenerAdapter a : providerServices.getProvidersAndServices(ResponseListenerAdapter.class)) {
            responseListener = a.adapt((ResponseListener)responseListener);
        }
        return responseListener;
    }
}

