/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import com.sun.jersey.server.impl.model.parameter.multivalued.CollectionStringExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.core.MultivaluedMap;

abstract class CollectionStringExtractor<V extends Collection<String>>
implements MultivaluedParameterExtractor {
    final String parameter;
    final String defaultValue;

    protected CollectionStringExtractor(String parameter, String defaultValue) {
        this.parameter = parameter;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.parameter;
    }

    public String getDefaultStringValue() {
        return this.defaultValue;
    }

    public Object extract(MultivaluedMap<String, String> parameters) {
        List stringList = (List)parameters.get((Object)this.parameter);
        if (stringList != null) {
            Collection copy = this.getInstance();
            copy.addAll(stringList);
            return copy;
        }
        if (this.defaultValue != null) {
            Collection l = this.getInstance();
            l.add(this.defaultValue);
            return l;
        }
        return this.getInstance();
    }

    protected abstract V getInstance();

    static MultivaluedParameterExtractor getInstance(Class c, String parameter, String defaultValue) {
        if (List.class == c) {
            return new ListString(parameter, defaultValue);
        }
        if (Set.class == c) {
            return new SetString(parameter, defaultValue);
        }
        if (SortedSet.class == c) {
            return new SortedSetString(parameter, defaultValue);
        }
        throw new RuntimeException();
    }
}

