/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.writer;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.writer.A2EXmlStreamWriterProxy;
import com.sun.jersey.json.impl.writer.JsonEncoder;
import com.sun.jersey.json.impl.writer.JsonXmlStreamWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class JsonXmlStreamWriter
implements XMLStreamWriter {
    Writer mainWriter;
    boolean stripRoot;
    char nsSeparator;
    final List<ProcessingState> processingStack = new ArrayList();
    int depth;
    final Collection<String> arrayElementNames = new LinkedList();
    final Collection<String> nonStringElementNames = new LinkedList();
    final Map<String, String> xml2JsonNs = new HashMap();

    private JsonXmlStreamWriter(Writer writer) {
        this(writer, JSONConfiguration.DEFAULT);
    }

    private JsonXmlStreamWriter(Writer writer, JSONConfiguration config) {
        this.mainWriter = writer;
        this.stripRoot = config.isRootUnwrapping();
        this.nsSeparator = config.getNsSeparator().charValue();
        if (null != config.getArrays()) {
            this.arrayElementNames.addAll(config.getArrays());
        }
        if (null != config.getNonStrings()) {
            this.nonStringElementNames.addAll(config.getNonStrings());
        }
        if (null != config.getXml2JsonNs()) {
            this.xml2JsonNs.putAll(config.getXml2JsonNs());
        }
        this.processingStack.add(this.createProcessingState());
        this.depth = 0;
    }

    public static XMLStreamWriter createWriter(Writer writer, JSONConfiguration config) {
        Collection attrsAsElems = config.getAttributeAsElements();
        if (attrsAsElems != null && !attrsAsElems.isEmpty()) {
            return new A2EXmlStreamWriterProxy((XMLStreamWriter)new JsonXmlStreamWriter(writer, config), attrsAsElems);
        }
        return new JsonXmlStreamWriter(writer, config);
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.mainWriter.close();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.mainWriter.flush();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        try {
            if (null != ((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter) {
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter.getContent());
            }
            if (null == ((ProcessingState)this.processingStack.get((int)this.depth)).lastWasPrimitive || !((ProcessingState)this.processingStack.get((int)this.depth)).lastWasPrimitive.booleanValue()) {
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("}");
            }
            this.pollStack();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        try {
            if (null != ((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter) {
                if (((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray) {
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(",");
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter.getContent());
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("]");
                } else if (this.isArrayElement(((ProcessingState)this.processingStack.get((int)this.depth)).lastName)) {
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray ? "," : "[");
                    ((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray = true;
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter.getContent());
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("]");
                } else {
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter.getContent());
                }
            }
            if (((ProcessingState)this.processingStack.get((int)this.depth)).writer.isEmpty) {
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("null");
            } else if (null == ((ProcessingState)this.processingStack.get((int)this.depth)).lastWasPrimitive || !((ProcessingState)this.processingStack.get((int)this.depth)).lastWasPrimitive.booleanValue()) {
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("}");
            }
            ((ProcessingState)this.processingStack.get((int)(this.depth - 1))).lastName = ((ProcessingState)this.processingStack.get((int)(this.depth - 1))).currentName;
            ((ProcessingState)this.processingStack.get((int)(this.depth - 1))).lastWasPrimitive = false;
            ((ProcessingState)this.processingStack.get((int)(this.depth - 1))).lastElementWriter = ((ProcessingState)this.processingStack.get((int)this.depth)).writer;
            this.pollStack();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
    }

    @Override
    public void writeCharacters(char[] text, int start, int length) throws XMLStreamException {
        this.writeCharacters(new String(text, start, length));
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (((ProcessingState)this.processingStack.get((int)this.depth)).isNotEmpty) {
            this.writeStartElement(null, "$", null);
            this._writeCharacters(text);
            this.writeEndElement();
        } else {
            this._writeCharacters(text);
        }
    }

    private void _writeCharacters(String text) throws XMLStreamException {
        try {
            if (this.isNonString(((ProcessingState)this.processingStack.get((int)(this.depth - 1))).currentName)) {
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(JsonEncoder.encode((String)text));
            } else {
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("\"" + JsonEncoder.encode((String)text) + "\"");
            }
            ((ProcessingState)this.processingStack.get((int)this.depth)).lastWasPrimitive = true;
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeDefaultNamespace(String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, null);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, null);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, null, localName, value);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, null);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, namespaceURI);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, namespaceURI, localName, value);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeEndElement();
    }

    private void pollStack() throws IOException {
        this.processingStack.remove(this.depth--);
    }

    private void printStack(String localName) {
        try {
            for (int d = 0; d <= this.depth; ++d) {
                this.mainWriter.write("\n**" + d + ":" + this.processingStack.get(d));
            }
            this.mainWriter.write("\n*** [" + localName + "]");
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean isArrayElement(String name) {
        if (null == name) {
            return false;
        }
        return this.arrayElementNames.contains(name);
    }

    private boolean isNonString(String name) {
        if (null == name) {
            return false;
        }
        return this.nonStringElementNames.contains(name);
    }

    private String getEffectiveName(String namespaceURI, String localName) {
        if (namespaceURI != null && this.xml2JsonNs.containsKey(namespaceURI)) {
            return String.format("%s%c%s", this.xml2JsonNs.get(namespaceURI), Character.valueOf(this.nsSeparator), localName);
        }
        return localName;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        String effectiveName = this.getEffectiveName(namespaceURI, localName);
        ((ProcessingState)this.processingStack.get((int)this.depth)).isNotEmpty = true;
        ((ProcessingState)this.processingStack.get((int)this.depth)).currentName = effectiveName;
        try {
            boolean isNextArrayElement = ((ProcessingState)this.processingStack.get((int)this.depth)).currentName.equals(((ProcessingState)this.processingStack.get((int)this.depth)).lastName);
            if (!isNextArrayElement) {
                if (this.isArrayElement(((ProcessingState)this.processingStack.get((int)this.depth)).lastName)) {
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray ? "," : "[");
                    ((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray = true;
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter.getContent());
                } else {
                    if (null != ((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter) {
                        if (((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray) {
                            ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(",");
                            ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter.getContent());
                            ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("]");
                        } else {
                            ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter.getContent());
                        }
                    }
                    ((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray = false;
                }
                if (null != ((ProcessingState)this.processingStack.get((int)this.depth)).lastName) {
                    if (((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray) {
                        ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("]");
                        ((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray = false;
                    }
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(",");
                }
                if (null == ((ProcessingState)this.processingStack.get((int)this.depth)).lastWasPrimitive) {
                    ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("{");
                }
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write("\"" + effectiveName + "\":");
            } else {
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray ? "," : "[");
                ((ProcessingState)this.processingStack.get((int)this.depth)).lastIsArray = true;
                ((ProcessingState)this.processingStack.get((int)this.depth)).writer.write(((ProcessingState)this.processingStack.get((int)this.depth)).lastElementWriter.getContent());
            }
            ++this.depth;
            this.processingStack.add(this.depth, this.createProcessingState());
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeStartElement(prefix, "@" + this.getEffectiveName(namespaceURI, localName), null);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    private ProcessingState createProcessingState() {
        switch (this.depth) {
            case 0: {
                return new ProcessingState((WriterAdapter)(this.stripRoot ? new DummyWriterAdapter() : new WriterAdapter(this.mainWriter)));
            }
            case 1: {
                return this.stripRoot ? new ProcessingState(new WriterAdapter(this.mainWriter)) : new ProcessingState();
            }
        }
        return new ProcessingState();
    }
}

