/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.scanning.uri;

import com.sun.jersey.core.spi.scanning.JarFileScanner;
import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.core.spi.scanning.uri.FileSchemeScanner;
import com.sun.jersey.core.spi.scanning.uri.UriSchemeScanner;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;

public class VfsSchemeScanner
implements UriSchemeScanner {
    public Set<String> getSchemes() {
        return new HashSet<String>(Arrays.asList("vfsfile", "vfszip", "vfs"));
    }

    public void scan(URI u, ScannerListener sl) {
        if (!u.getScheme().equalsIgnoreCase("vfszip")) {
            new FileSchemeScanner().scan(UriBuilder.fromUri((URI)u).scheme("file").build(new Object[0]), sl);
        } else {
            String su = u.toString();
            int webInfIndex = su.indexOf("/WEB-INF/classes");
            if (webInfIndex != -1) {
                String war = su.substring(0, webInfIndex);
                String path = su.substring(webInfIndex + 1);
                int warParentIndex = war.lastIndexOf(47);
                String warParent = su.substring(0, warParentIndex);
                if (warParent.endsWith(".ear")) {
                    String warName = su.substring(warParentIndex + 1, war.length());
                    try {
                        JarFileScanner.scan((InputStream)new URL(warParent.replace("vfszip", "file")).openStream(), (String)"", (ScannerListener)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    catch (IOException ex) {
                        throw new ScannerException("IO error when scanning war " + u, (Throwable)ex);
                    }
                } else {
                    try {
                        JarFileScanner.scan((InputStream)new URL(war.replace("vfszip", "file")).openStream(), (String)path, (ScannerListener)sl);
                    }
                    catch (IOException ex) {
                        throw new ScannerException("IO error when scanning war " + u, (Throwable)ex);
                    }
                }
            } else {
                try {
                    JarFileScanner.scan((InputStream)new URL(su).openStream(), (String)"", (ScannerListener)sl);
                }
                catch (IOException ex) {
                    throw new ScannerException("IO error when scanning jar " + u, (Throwable)ex);
                }
            }
        }
    }
}

