/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.reflection;

import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.impl.ImplMessages;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReflectionHelper {
    public static Class getDeclaringClass(AccessibleObject ao) {
        if (ao instanceof Method) {
            return ((Method)ao).getDeclaringClass();
        }
        if (ao instanceof Field) {
            return ((Field)ao).getDeclaringClass();
        }
        if (ao instanceof Constructor) {
            return ((Constructor)ao).getDeclaringClass();
        }
        throw new RuntimeException();
    }

    public static String objectToString(Object o) {
        if (o == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(o.getClass().getName()).append('@').append(Integer.toHexString(o.hashCode()));
        return sb.toString();
    }

    public static String methodInstanceToString(Object o, Method m) {
        StringBuffer sb = new StringBuffer();
        sb.append(o.getClass().getName()).append('@').append(Integer.toHexString(o.hashCode())).append('.').append(m.getName()).append('(');
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            sb.append(ReflectionHelper.getTypeName(params[i]));
            if (i >= params.length - 1) continue;
            sb.append(",");
        }
        sb.append(')');
        return sb.toString();
    }

    private static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static Class classForName(String name) {
        return ReflectionHelper.classForName((String)name, (ClassLoader)ReflectionHelper.getContextClassLoader());
    }

    public static Class classForName(String name, ClassLoader cl) {
        if (cl != null) {
            try {
                return Class.forName(name, false, cl);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class classForNameWithException(String name) throws ClassNotFoundException {
        return ReflectionHelper.classForNameWithException((String)name, (ClassLoader)ReflectionHelper.getContextClassLoader());
    }

    public static Class classForNameWithException(String name, ClassLoader cl) throws ClassNotFoundException {
        if (cl != null) {
            try {
                return Class.forName(name, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void setAccessibleMethod(Method m) {
        if (Modifier.isPublic(m.getModifiers())) {
            return;
        }
        AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Class getGenericClass(Type parameterizedType) throws IllegalArgumentException {
        Type t = ReflectionHelper.getTypeArgumentOfParameterizedType((Type)parameterizedType);
        if (t == null) {
            return null;
        }
        Class c = ReflectionHelper.getClassOfType((Type)t);
        if (c == null) {
            throw new IllegalArgumentException(ImplMessages.GENERIC_TYPE_NOT_SUPPORTED((Object)t, (Object)parameterizedType));
        }
        return c;
    }

    public static TypeClassPair getTypeArgumentAndClass(Type parameterizedType) throws IllegalArgumentException {
        Type t = ReflectionHelper.getTypeArgumentOfParameterizedType((Type)parameterizedType);
        if (t == null) {
            return null;
        }
        Class c = ReflectionHelper.getClassOfType((Type)t);
        if (c == null) {
            throw new IllegalArgumentException(ImplMessages.GENERIC_TYPE_NOT_SUPPORTED((Object)t, (Object)parameterizedType));
        }
        return new TypeClassPair(t, c);
    }

    private static Type getTypeArgumentOfParameterizedType(Type parameterizedType) {
        if (!(parameterizedType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType type = (ParameterizedType)parameterizedType;
        Type[] genericTypes = type.getActualTypeArguments();
        if (genericTypes.length != 1) {
            return null;
        }
        return genericTypes[0];
    }

    private static Class getClassOfType(Type type) {
        ParameterizedType subType;
        Type t;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type t2 = arrayType.getGenericComponentType();
            if (t2 instanceof Class) {
                return ReflectionHelper.getArrayClass((Class)((Class)t2));
            }
        } else if (type instanceof ParameterizedType && (t = (subType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    public static Class getArrayClass(Class c) {
        try {
            Object o = Array.newInstance(c, 0);
            return o.getClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Method getValueOfStringMethod(Class c) {
        try {
            Method m = c.getDeclaredMethod("valueOf", String.class);
            if (!Modifier.isStatic(m.getModifiers()) && m.getReturnType() == c) {
                return null;
            }
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getFromStringStringMethod(Class c) {
        try {
            Method m = c.getDeclaredMethod("fromString", String.class);
            if (!Modifier.isStatic(m.getModifiers()) && m.getReturnType() == c) {
                return null;
            }
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getStringConstructor(Class c) {
        try {
            return c.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class[] getParameterizedClassArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as = pt.getActualTypeArguments();
            Class[] cas = new Class[as.length];
            for (int i = 0; i < as.length; ++i) {
                Type a = as[i];
                if (a instanceof Class) {
                    cas[i] = (Class)a;
                    continue;
                }
                if (a instanceof ParameterizedType) {
                    pt = (ParameterizedType)a;
                    cas[i] = (Class)pt.getRawType();
                    continue;
                }
                if (!(a instanceof TypeVariable)) continue;
                ClassTypePair ctp = ReflectionHelper.resolveTypeVariable((Class)p.concreteClass, (Class)p.declaringClass, (TypeVariable)((TypeVariable)a));
                cas[i] = ctp != null ? ctp.c : Object.class;
            }
            return cas;
        }
        return null;
    }

    public static Type[] getParameterizedTypeArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as = pt.getActualTypeArguments();
            Type[] ras = new Type[as.length];
            for (int i = 0; i < as.length; ++i) {
                Type a = as[i];
                if (a instanceof Class) {
                    ras[i] = a;
                    continue;
                }
                if (a instanceof ParameterizedType) {
                    pt = (ParameterizedType)a;
                    ras[i] = a;
                    continue;
                }
                if (!(a instanceof TypeVariable)) continue;
                ClassTypePair ctp = ReflectionHelper.resolveTypeVariable((Class)p.concreteClass, (Class)p.declaringClass, (TypeVariable)((TypeVariable)a));
                ras[i] = ctp.t;
            }
            return ras;
        }
        return null;
    }

    public static DeclaringClassInterfacePair getClass(Class concrete, Class iface) {
        return ReflectionHelper.getClass((Class)concrete, (Class)iface, (Class)concrete);
    }

    private static DeclaringClassInterfacePair getClass(Class concrete, Class iface, Class c) {
        Type[] gis = c.getGenericInterfaces();
        DeclaringClassInterfacePair p = ReflectionHelper.getType((Class)concrete, (Class)iface, (Class)c, (Type[])gis);
        if (p != null) {
            return p;
        }
        if ((c = c.getSuperclass()) == null || c == Object.class) {
            return null;
        }
        return ReflectionHelper.getClass((Class)concrete, (Class)iface, c);
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class iface, Class c, Type[] ts) {
        for (Type t : ts) {
            DeclaringClassInterfacePair p = ReflectionHelper.getType((Class)concrete, (Class)iface, (Class)c, (Type)t);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class iface, Class c, Type t) {
        if (t instanceof Class) {
            if (t == iface) {
                return new DeclaringClassInterfacePair(concrete, c, t, null);
            }
            return ReflectionHelper.getClass((Class)concrete, (Class)iface, (Class)((Class)t));
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getRawType() == iface) {
                return new DeclaringClassInterfacePair(concrete, c, t, null);
            }
            return ReflectionHelper.getClass((Class)concrete, (Class)iface, (Class)((Class)pt.getRawType()));
        }
        return null;
    }

    public static ClassTypePair resolveTypeVariable(Class c, Class dc, TypeVariable tv) {
        return ReflectionHelper.resolveTypeVariable((Class)c, (Class)dc, (TypeVariable)tv, new HashMap());
    }

    private static ClassTypePair resolveTypeVariable(Class c, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] gis;
        for (Type gi : gis = c.getGenericInterfaces()) {
            ParameterizedType pt;
            ClassTypePair ctp;
            if (!(gi instanceof ParameterizedType) || (ctp = ReflectionHelper.resolveTypeVariable((ParameterizedType)(pt = (ParameterizedType)gi), (Class)((Class)pt.getRawType()), (Class)dc, (TypeVariable)tv, map)) == null) continue;
            return ctp;
        }
        Type gsc = c.getGenericSuperclass();
        if (gsc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gsc;
            return ReflectionHelper.resolveTypeVariable((ParameterizedType)pt, c.getSuperclass(), (Class)dc, (TypeVariable)tv, map);
        }
        if (gsc instanceof Class) {
            return ReflectionHelper.resolveTypeVariable(c.getSuperclass(), (Class)dc, (TypeVariable)tv, map);
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(ParameterizedType pt, Class c, Class dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] typeArguments = pt.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParameters = c.getTypeParameters();
        HashMap submap = new HashMap();
        for (int i = 0; i < typeArguments.length; ++i) {
            if (typeArguments[i] instanceof TypeVariable) {
                Type t = map.get(typeArguments[i]);
                submap.put(typeParameters[i], t);
                continue;
            }
            submap.put(typeParameters[i], typeArguments[i]);
        }
        if (c == dc) {
            Type t = (Type)submap.get(tv);
            if (t instanceof Class) {
                return new ClassTypePair((Class)t);
            }
            if (t instanceof GenericArrayType) {
                if ((t = ((GenericArrayType)t).getGenericComponentType()) instanceof Class) {
                    c = (Class)t;
                    try {
                        return new ClassTypePair(ReflectionHelper.getArrayClass((Class)c));
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                if (t instanceof ParameterizedType) {
                    Type rt = ((ParameterizedType)t).getRawType();
                    if (!(rt instanceof Class)) {
                        return null;
                    }
                    c = (Class)rt;
                    try {
                        return new ClassTypePair(ReflectionHelper.getArrayClass((Class)c), t);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
            if (t instanceof ParameterizedType) {
                pt = (ParameterizedType)t;
                if (pt.getRawType() instanceof Class) {
                    return new ClassTypePair((Class)pt.getRawType(), (Type)pt);
                }
                return null;
            }
            return null;
        }
        return ReflectionHelper.resolveTypeVariable((Class)c, (Class)dc, (TypeVariable)tv, submap);
    }

    public static Method findMethodOnClass(Class c, Method m) {
        try {
            return c.getMethod(m.getName(), m.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            for (Method _m : c.getMethods()) {
                if (!_m.getName().equals(m.getName()) || _m.getParameterTypes().length != m.getParameterTypes().length || !ReflectionHelper.compareParameterTypes((Type[])m.getGenericParameterTypes(), (Type[])_m.getGenericParameterTypes())) continue;
                return _m;
            }
            return null;
        }
    }

    private static boolean compareParameterTypes(Type[] ts, Type[] _ts) {
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i].equals(_ts[i]) || _ts[i] instanceof TypeVariable) continue;
            return false;
        }
        return true;
    }
}

