/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.header;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import com.sun.jersey.core.impl.provider.header.WriterUtil;
import com.sun.jersey.spi.HeaderDelegateProvider;
import javax.ws.rs.core.Cookie;

public class CookieProvider
implements HeaderDelegateProvider<Cookie> {
    public boolean supports(Class<?> type) {
        return type == Cookie.class;
    }

    public String toString(Cookie cookie) {
        StringBuilder b = new StringBuilder();
        b.append("$Version=").append(cookie.getVersion()).append(';');
        b.append(cookie.getName()).append('=');
        WriterUtil.appendQuotedIfWhitespace((StringBuilder)b, (String)cookie.getValue());
        if (cookie.getDomain() != null) {
            b.append(";$Domain=");
            WriterUtil.appendQuotedIfWhitespace((StringBuilder)b, (String)cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            b.append(";$Path=");
            WriterUtil.appendQuotedIfWhitespace((StringBuilder)b, (String)cookie.getPath());
        }
        return b.toString();
    }

    public Cookie fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        return HttpHeaderReader.readCookie((String)header);
    }
}

