/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.uri;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;

/*
 * Exception performing whole class analysis ignored.
 */
public class UriComponent {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] SCHEME = new String[]{"0-9", "A-Z", "a-z", "+", "-", "."};
    private static final String[] UNRESERVED = new String[]{"0-9", "A-Z", "a-z", "-", ".", "_", "~"};
    private static final String[] SUB_DELIMS = new String[]{"!", "$", "&", "'", "(", ")", "*", "+", ",", ";", "="};
    private static final boolean[][] ENCODING_TABLES = UriComponent.initEncodingTables();
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final int[] HEX_TABLE = UriComponent.initHexTable();

    private UriComponent() {
    }

    public static void validate(String s, Type t) {
        UriComponent.validate((String)s, (Type)t, (boolean)false);
    }

    public static void validate(String s, Type t, boolean template) {
        int i = UriComponent._valid((String)s, (Type)t, (boolean)template);
        if (i > -1) {
            throw new IllegalArgumentException("The string '" + s + "' for the URI component " + t + " contains an invalid character, '" + s.charAt(i) + "', at index " + i);
        }
    }

    public static boolean valid(String s, Type t) {
        return UriComponent.valid((String)s, (Type)t, (boolean)false);
    }

    public static boolean valid(String s, Type t, boolean template) {
        return UriComponent._valid((String)s, (Type)t, (boolean)template) == -1;
    }

    private static int _valid(String s, Type t, boolean template) {
        boolean[] table = ENCODING_TABLES[t.ordinal()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c >= '\u0080' || c == '%' || table[c]) && c < '\u0080' || template && (c == '{' || c == '}')) continue;
            return i;
        }
        return -1;
    }

    public static String contextualEncode(String s, Type t) {
        return UriComponent._encode((String)s, (Type)t, (boolean)false, (boolean)true);
    }

    public static String contextualEncode(String s, Type t, boolean template) {
        return UriComponent._encode((String)s, (Type)t, (boolean)template, (boolean)true);
    }

    public static String encode(String s, Type t) {
        return UriComponent._encode((String)s, (Type)t, (boolean)false, (boolean)false);
    }

    public static String encode(String s, Type t, boolean template) {
        return UriComponent._encode((String)s, (Type)t, (boolean)template, (boolean)false);
    }

    public static String encodeTemplateNames(String s) {
        int i = s.indexOf(123);
        if (i != -1) {
            s = s.replace("{", "%7B");
        }
        if ((i = s.indexOf(125)) != -1) {
            s = s.replace("}", "%7D");
        }
        return s;
    }

    private static String _encode(String s, Type t, boolean template, boolean contextualEncode) {
        boolean[] table = ENCODING_TABLES[t.ordinal()];
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080' && table[c]) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (template && (c == '{' || c == '}')) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (contextualEncode && c == '%' && i + 2 < s.length() && UriComponent.isHexCharacter((char)s.charAt(i + 1)) && UriComponent.isHexCharacter((char)s.charAt(i + 2))) {
                if (sb != null) {
                    sb.append('%').append(s.charAt(i + 1)).append(s.charAt(i + 2));
                }
                i += 2;
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(s.substring(0, i));
            }
            if (c < '\u0080') {
                if (c == ' ' && t == Type.QUERY_PARAM) {
                    sb.append('+');
                    continue;
                }
                UriComponent.appendPercentEncodedOctet((StringBuilder)sb, (int)c);
                continue;
            }
            UriComponent.appendUTF8EncodedCharacter((StringBuilder)sb, (char)c);
        }
        return sb == null ? s : sb.toString();
    }

    private static void appendPercentEncodedOctet(StringBuilder sb, int b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4]);
        sb.append(HEX_DIGITS[b & 0xF]);
    }

    private static void appendUTF8EncodedCharacter(StringBuilder sb, char c) {
        ByteBuffer bb = UTF_8_CHARSET.encode("" + c);
        while (bb.hasRemaining()) {
            UriComponent.appendPercentEncodedOctet((StringBuilder)sb, (int)(bb.get() & 0xFF));
        }
    }

    private static boolean[][] initEncodingTables() {
        boolean[][] tables = new boolean[Type.values().length][];
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(Arrays.asList(SCHEME));
        tables[Type.SCHEME.ordinal()] = UriComponent.initEncodingTable(l);
        l.clear();
        l.addAll(Arrays.asList(UNRESERVED));
        tables[Type.UNRESERVED.ordinal()] = UriComponent.initEncodingTable(l);
        l.addAll(Arrays.asList(SUB_DELIMS));
        tables[Type.HOST.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PORT.ordinal()] = UriComponent.initEncodingTable(Arrays.asList("0-9"));
        l.add(":");
        tables[Type.USER_INFO.ordinal()] = UriComponent.initEncodingTable(l);
        l.add("@");
        tables[Type.AUTHORITY.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PATH_SEGMENT.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PATH_SEGMENT.ordinal()][59] = false;
        tables[Type.MATRIX_PARAM.ordinal()] = (boolean[])tables[Type.PATH_SEGMENT.ordinal()].clone();
        tables[Type.MATRIX_PARAM.ordinal()][61] = false;
        l.add("/");
        tables[Type.PATH.ordinal()] = UriComponent.initEncodingTable(l);
        l.add("?");
        tables[Type.QUERY.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.FRAGMENT.ordinal()] = tables[Type.QUERY.ordinal()];
        tables[Type.QUERY_PARAM.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.QUERY_PARAM.ordinal()][61] = false;
        tables[Type.QUERY_PARAM.ordinal()][43] = false;
        tables[Type.QUERY_PARAM.ordinal()][38] = false;
        return tables;
    }

    private static boolean[] initEncodingTable(List<String> allowed) {
        boolean[] table = new boolean[128];
        for (String range : allowed) {
            if (range.length() == 1) {
                table[range.charAt((int)0)] = true;
                continue;
            }
            if (range.length() != 3 || range.charAt(1) != '-') continue;
            for (int i = range.charAt(0); i <= range.charAt(2); ++i) {
                table[i] = true;
            }
        }
        return table;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String s, Type t) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.indexOf(37) < 0) {
            if (t != Type.QUERY_PARAM) return s;
            if (s.indexOf(43) < 0) {
                return s;
            }
        } else {
            if (n < 2) {
                throw new IllegalArgumentException("Malformed percent-encoded octet at index 1");
            }
            if (s.charAt(n - 2) == '%') {
                throw new IllegalArgumentException("Malformed percent-encoded octet at index " + (n - 2));
            }
        }
        if (t == null) {
            return UriComponent.decode((String)s, (int)n);
        }
        switch (1.$SwitchMap$com$sun$jersey$api$uri$UriComponent$Type[t.ordinal()]) {
            case 1: {
                return UriComponent.decodeHost((String)s, (int)n);
            }
            case 2: {
                return UriComponent.decodeQueryParam((String)s, (int)n);
            }
        }
        return UriComponent.decode((String)s, (int)n);
    }

    public static MultivaluedMap<String, String> decodeQuery(URI u, boolean decode) {
        return UriComponent.decodeQuery((String)u.getRawQuery(), (boolean)decode);
    }

    public static MultivaluedMap<String, String> decodeQuery(String q, boolean decode) {
        MultivaluedMapImpl queryParameters = new MultivaluedMapImpl();
        if (q == null || q.length() == 0) {
            return queryParameters;
        }
        int s = 0;
        int e = 0;
        do {
            if ((e = q.indexOf(38, s)) == -1) {
                UriComponent.decodeQueryParam((MultivaluedMap)queryParameters, (String)q.substring(s), (boolean)decode);
                continue;
            }
            if (e <= s) continue;
            UriComponent.decodeQueryParam((MultivaluedMap)queryParameters, (String)q.substring(s, e), (boolean)decode);
        } while ((s = e + 1) > 0 && s < q.length());
        return queryParameters;
    }

    private static void decodeQueryParam(MultivaluedMap<String, String> params, String param, boolean decode) {
        try {
            int equals = param.indexOf(61);
            if (equals > 0) {
                params.add((Object)URLDecoder.decode(param.substring(0, equals), "UTF-8"), (Object)(decode ? URLDecoder.decode(param.substring(equals + 1), "UTF-8") : param.substring(equals + 1)));
            } else if (equals != 0 && param.length() > 0) {
                params.add((Object)URLDecoder.decode(param, "UTF-8"), (Object)"");
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static List<PathSegment> decodePath(URI u, boolean decode) {
        String rawPath = u.getRawPath();
        if (rawPath != null && rawPath.length() > 0 && rawPath.charAt(0) == '/') {
            rawPath = rawPath.substring(1);
        }
        return UriComponent.decodePath((String)rawPath, (boolean)decode);
    }

    public static List<PathSegment> decodePath(String path, boolean decode) {
        LinkedList<PathSegment> segments = new LinkedList<PathSegment>();
        if (path == null) {
            return segments;
        }
        int s = 0;
        int e = -1;
        do {
            if ((e = path.indexOf(47, s = e + 1)) > s) {
                UriComponent.decodePathSegment(segments, (String)path.substring(s, e), (boolean)decode);
                continue;
            }
            if (e != s) continue;
            segments.add(PathSegmentImpl.access$000());
        } while (e != -1);
        if (s < path.length()) {
            UriComponent.decodePathSegment(segments, (String)path.substring(s), (boolean)decode);
        } else {
            segments.add(PathSegmentImpl.access$000());
        }
        return segments;
    }

    public static void decodePathSegment(List<PathSegment> segments, String segment, boolean decode) {
        int colon = segment.indexOf(59);
        if (colon != -1) {
            segments.add((PathSegment)new PathSegmentImpl(colon == 0 ? "" : segment.substring(0, colon), decode, UriComponent.decodeMatrix((String)segment, (boolean)decode)));
        } else {
            segments.add((PathSegment)new PathSegmentImpl(segment, decode));
        }
    }

    public static MultivaluedMap<String, String> decodeMatrix(String pathSegment, boolean decode) {
        MultivaluedMapImpl matrixMap = new MultivaluedMapImpl();
        int s = pathSegment.indexOf(59) + 1;
        if (s == 0 || s == pathSegment.length()) {
            return matrixMap;
        }
        int e = 0;
        do {
            if ((e = pathSegment.indexOf(59, s)) == -1) {
                UriComponent.decodeMatrixParam((MultivaluedMap)matrixMap, (String)pathSegment.substring(s), (boolean)decode);
                continue;
            }
            if (e <= s) continue;
            UriComponent.decodeMatrixParam((MultivaluedMap)matrixMap, (String)pathSegment.substring(s, e), (boolean)decode);
        } while ((s = e + 1) > 0 && s < pathSegment.length());
        return matrixMap;
    }

    private static void decodeMatrixParam(MultivaluedMap<String, String> params, String param, boolean decode) {
        int equals = param.indexOf(61);
        if (equals > 0) {
            params.add((Object)UriComponent.decode((String)param.substring(0, equals), (Type)Type.MATRIX_PARAM), (Object)(decode ? UriComponent.decode((String)param.substring(equals + 1), (Type)Type.MATRIX_PARAM) : param.substring(equals + 1)));
        } else if (equals != 0 && param.length() > 0) {
            params.add((Object)UriComponent.decode((String)param, (Type)Type.MATRIX_PARAM), (Object)"");
        }
    }

    private static String decode(String s, int n) {
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = null;
        int i = 0;
        while (i < n) {
            char c;
            if ((c = s.charAt(i++)) != '%') {
                sb.append(c);
                continue;
            }
            bb = UriComponent.decodePercentEncodedOctets((String)s, (int)i, bb);
            i = UriComponent.decodeOctets((int)i, (ByteBuffer)bb, (StringBuilder)sb);
        }
        return sb.toString();
    }

    private static String decodeQueryParam(String s, int n) {
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = null;
        int i = 0;
        while (i < n) {
            char c;
            if ((c = s.charAt(i++)) != '%') {
                if (c != '+') {
                    sb.append(c);
                    continue;
                }
                sb.append(' ');
                continue;
            }
            bb = UriComponent.decodePercentEncodedOctets((String)s, (int)i, bb);
            i = UriComponent.decodeOctets((int)i, (ByteBuffer)bb, (StringBuilder)sb);
        }
        return sb.toString();
    }

    private static String decodeHost(String s, int n) {
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = null;
        boolean betweenBrackets = false;
        int i = 0;
        while (i < n) {
            char c;
            if ((c = s.charAt(i++)) == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c == ']') {
                betweenBrackets = false;
            }
            if (c != '%' || betweenBrackets) {
                sb.append(c);
                continue;
            }
            bb = UriComponent.decodePercentEncodedOctets((String)s, (int)i, bb);
            i = UriComponent.decodeOctets((int)i, (ByteBuffer)bb, (StringBuilder)sb);
        }
        return sb.toString();
    }

    private static ByteBuffer decodePercentEncodedOctets(String s, int i, ByteBuffer bb) {
        if (bb == null) {
            bb = ByteBuffer.allocate(1);
        } else {
            bb.clear();
        }
        while (true) {
            bb.put((byte)(UriComponent.decodeHex((String)s, (int)i++) << 4 | UriComponent.decodeHex((String)s, (int)i++)));
            if (i == s.length() || s.charAt(i++) != '%') break;
            if (bb.position() != bb.capacity()) continue;
            bb.flip();
            ByteBuffer bb_new = ByteBuffer.allocate(s.length() / 3);
            bb_new.put(bb);
            bb = bb_new;
        }
        bb.flip();
        return bb;
    }

    private static int decodeOctets(int i, ByteBuffer bb, StringBuilder sb) {
        if (bb.limit() == 1 && (bb.get(0) & 0xFF) < 128) {
            sb.append((char)bb.get(0));
            return i + 2;
        }
        CharBuffer cb = UTF_8_CHARSET.decode(bb);
        sb.append(cb.toString());
        return i + bb.limit() * 3 - 1;
    }

    private static int decodeHex(String s, int i) {
        int v = UriComponent.decodeHex((char)s.charAt(i));
        if (v == -1) {
            throw new IllegalArgumentException("Malformed percent-encoded octet at index " + i + ", invalid hexadecimal digit '" + s.charAt(i) + "'");
        }
        return v;
    }

    private static int[] initHexTable() {
        int c;
        int[] table = new int[128];
        Arrays.fill(table, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            table[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            table[c] = c - 65 + 10;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            table[c] = c - 97 + 10;
        }
        return table;
    }

    private static int decodeHex(char c) {
        return c < '\u0080' ? HEX_TABLE[c] : -1;
    }

    private static boolean isHexCharacter(char c) {
        return c < '\u0080' && HEX_TABLE[c] != -1;
    }
}

