/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client.filter;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPDigestAuthFilter;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HTTPDigestAuthFilter
extends ClientFilter {
    private static final int CNONCE_NB_BYTES = 4;
    private static final SecureRandom randomGenerator;
    private static final Pattern TOKENS_PATTERN;
    private final String user;
    private final String pass;
    private final ThreadLocal<State> state = new /* Unavailable Anonymous Inner Class!! */;

    public HTTPDigestAuthFilter(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    private static void addKeyVal(StringBuffer buffer, String key, String val, boolean withQuotes) {
        String quote = withQuotes ? "\"" : "";
        buffer.append(key + '=' + quote + val + quote + ',');
    }

    private static void addKeyVal(StringBuffer buffer, String key, String val) {
        HTTPDigestAuthFilter.addKeyVal((StringBuffer)buffer, (String)key, (String)val, (boolean)true);
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    static String MD5(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
            byte[] md5hash = md.digest();
            return HTTPDigestAuthFilter.convertToHex((byte[])md5hash);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static String concatMD5(String ... vals) {
        StringBuilder buff = new StringBuilder();
        for (String val : vals) {
            buff.append(val);
            buff.append(':');
        }
        buff.deleteCharAt(buff.length() - 1);
        return HTTPDigestAuthFilter.MD5((String)buff.toString());
    }

    String randHexBytes(int nbBytes) {
        byte[] bytes = new byte[nbBytes];
        randomGenerator.nextBytes(bytes);
        return HTTPDigestAuthFilter.convertToHex((byte[])bytes);
    }

    static HashMap<String, String> parseHeaders(Collection<String> lines) {
        for (String line : lines) {
            String[] parts = line.trim().split("\\s+", 2);
            if (parts.length != 2 || !parts[0].toLowerCase().equals("digest")) continue;
            Matcher match = TOKENS_PATTERN.matcher(parts[1]);
            HashMap<String, String> result = new HashMap<String, String>();
            while (match.find()) {
                int nbGroups = match.groupCount();
                if (nbGroups != 4) continue;
                String key = match.group(1);
                String valNoQuotes = match.group(3);
                String valQuotes = match.group(4);
                result.put(key, valNoQuotes == null ? valQuotes : valNoQuotes);
            }
            return result;
        }
        return null;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ClientResponse response;
        boolean reqHadAuthHeaders = false;
        if (((State)this.state.get()).nextNonce != null) {
            String response2;
            reqHadAuthHeaders = true;
            String qopStr = null;
            if (((State)this.state.get()).qop != null) {
                qopStr = ((State)this.state.get()).qop == QOP.AUTH_INT ? "auth-int" : "auth";
            }
            StringBuffer buff = new StringBuffer();
            buff.append("Digest ");
            HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"username", (String)this.user);
            HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"realm", (String)((State)this.state.get()).realm);
            HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"nonce", (String)((State)this.state.get()).nextNonce);
            if (((State)this.state.get()).opaque != null) {
                HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"opaque", (String)((State)this.state.get()).opaque);
            }
            if (((State)this.state.get()).algorithm != null) {
                HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"algorithm", (String)((State)this.state.get()).algorithm, (boolean)false);
            }
            if (((State)this.state.get()).qop != null) {
                HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"qop", (String)qopStr, (boolean)false);
            }
            String HA1 = HTTPDigestAuthFilter.concatMD5((String[])new String[]{this.user, ((State)this.state.get()).realm, this.pass});
            String uri = request.getURI().getPath();
            HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"uri", (String)uri);
            String HA2 = ((State)this.state.get()).qop == QOP.AUTH_INT && request.getEntity() != null ? HTTPDigestAuthFilter.concatMD5((String[])new String[]{request.getMethod(), uri, request.getEntity().toString()}) : HTTPDigestAuthFilter.concatMD5((String[])new String[]{request.getMethod(), uri});
            if (((State)this.state.get()).qop == null) {
                response2 = HTTPDigestAuthFilter.concatMD5((String[])new String[]{HA1, ((State)this.state.get()).nextNonce, HA2});
            } else {
                String cnonce = this.randHexBytes(4);
                String nc = String.format("%08x", ((State)this.state.get()).counter);
                ++((State)this.state.get()).counter;
                HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"cnonce", (String)cnonce);
                HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"nc", (String)nc, (boolean)false);
                response2 = HTTPDigestAuthFilter.concatMD5((String[])new String[]{HA1, ((State)this.state.get()).nextNonce, nc, cnonce, qopStr, HA2});
            }
            HTTPDigestAuthFilter.addKeyVal((StringBuffer)buff, (String)"response", (String)response2);
            buff.deleteCharAt(buff.length() - 1);
            String authLine = buff.toString();
            request.getHeaders().add((Object)"Authorization", (Object)authLine);
        }
        if ((response = this.getNext().handle(request)).getClientResponseStatus() == ClientResponse.Status.UNAUTHORIZED) {
            boolean stale;
            HashMap map = HTTPDigestAuthFilter.parseHeaders((Collection)((Collection)response.getHeaders().get((Object)"WWW-Authenticate")));
            if (map == null) {
                return response;
            }
            ((State)this.state.get()).realm = (String)map.get("realm");
            ((State)this.state.get()).nextNonce = (String)map.get("nonce");
            ((State)this.state.get()).opaque = (String)map.get("opaque");
            ((State)this.state.get()).algorithm = (String)map.get("algorithm");
            ((State)this.state.get()).domain = (String)map.get("domain");
            String qop = (String)map.get("qop");
            ((State)this.state.get()).qop = qop == null ? null : (qop.contains("auth-int") ? QOP.AUTH_INT : (qop.contains("auth") ? QOP.AUTH : null));
            String staleStr = (String)map.get("stale");
            boolean bl = stale = staleStr != null && staleStr.toLowerCase().equals("true");
            if (stale || !reqHadAuthHeaders) {
                return this.handle(request);
            }
            return response;
        }
        return response;
    }

    static {
        try {
            randomGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            throw new Error(e);
        }
        TOKENS_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*(\"([^\"]+)\"|(\\w+))\\s*,?\\s*");
    }
}

