/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResourceLinkHeaders;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.provider.CompletableReader;
import com.sun.jersey.core.util.ReaderWriter;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientResponse {
    private static final Logger LOGGER = Logger.getLogger(ClientResponse.class.getName());
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    protected static final RuntimeDelegate.HeaderDelegate<EntityTag> entityTagDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class);
    protected static final RuntimeDelegate.HeaderDelegate<Date> dateDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(Date.class);
    private Map<String, Object> properties;
    private int status;
    private InBoundHeaders headers;
    private boolean isEntityBuffered;
    private InputStream entity;
    private MessageBodyWorkers workers;

    public ClientResponse(int status, InBoundHeaders headers, InputStream entity, MessageBodyWorkers workers) {
        this.status = status;
        this.headers = headers;
        this.entity = entity;
        this.workers = workers;
    }

    public Client getClient() {
        return (Client)this.getProperties().get(Client.class.getName());
    }

    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = new HashMap<String, Object>();
        return this.properties;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(Response.StatusType status) {
        this.setStatus(status.getStatusCode());
    }

    public Status getClientResponseStatus() {
        return Status.fromStatusCode((int)this.status);
    }

    @Deprecated
    public Response.Status getResponseStatus() {
        return Response.Status.fromStatusCode((int)this.status);
    }

    @Deprecated
    public void setResponseStatus(Response.StatusType status) {
        this.setStatus(status);
    }

    @Deprecated
    public MultivaluedMap<String, String> getMetadata() {
        return this.getHeaders();
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public boolean hasEntity() {
        try {
            if (this.entity.available() > 0) {
                return true;
            }
            if (this.entity.markSupported()) {
                this.entity.mark(1);
                int i = this.entity.read();
                this.entity.reset();
                return i != -1;
            }
            return false;
        }
        catch (IOException ex) {
            throw new ClientHandlerException((Throwable)ex);
        }
    }

    public InputStream getEntityInputStream() {
        return this.entity;
    }

    public void setEntityInputStream(InputStream entity) {
        this.isEntityBuffered = false;
        this.entity = entity;
    }

    public <T> T getEntity(Class<T> c) throws ClientHandlerException, UniformInterfaceException {
        return (T)this.getEntity(c, c);
    }

    public <T> T getEntity(GenericType<T> gt) throws ClientHandlerException, UniformInterfaceException {
        return (T)this.getEntity(gt.getRawClass(), gt.getType());
    }

    private <T> T getEntity(Class<T> c, Type type) {
        MessageBodyReader br;
        if (this.getStatus() == 204) {
            throw new UniformInterfaceException(this);
        }
        MediaType mediaType = this.getType();
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if ((br = this.workers.getMessageBodyReader(c, type, EMPTY_ANNOTATIONS, mediaType)) == null) {
            this.close();
            String message = "A message body reader for Java class " + c.getName() + ", and Java type " + type + ", and MIME media type " + mediaType + " was not found";
            LOGGER.severe(message);
            Map m = this.workers.getReaders(mediaType);
            LOGGER.severe("The registered message body readers compatible with the MIME media type are:\n" + this.workers.readersToString(m));
            throw new ClientHandlerException(message);
        }
        try {
            Object t = br.readFrom(c, type, EMPTY_ANNOTATIONS, mediaType, (MultivaluedMap)this.headers, this.entity);
            if (br instanceof CompletableReader) {
                t = ((CompletableReader)br).complete(t);
            }
            if (!(t instanceof Closeable)) {
                this.close();
            }
            return (T)t;
        }
        catch (IOException ex) {
            this.close();
            throw new ClientHandlerException((Throwable)ex);
        }
    }

    public void bufferEntity() throws ClientHandlerException {
        if (this.isEntityBuffered) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ReaderWriter.writeTo((InputStream)this.entity, (OutputStream)baos);
        }
        catch (IOException ex) {
            throw new ClientHandlerException((Throwable)ex);
        }
        finally {
            this.close();
        }
        this.entity = new ByteArrayInputStream(baos.toByteArray());
        this.isEntityBuffered = true;
    }

    public void close() throws ClientHandlerException {
        try {
            this.entity.close();
        }
        catch (IOException e) {
            throw new ClientHandlerException((Throwable)e);
        }
    }

    public MediaType getType() {
        String ct = (String)this.getHeaders().getFirst((Object)"Content-Type");
        return ct != null ? MediaType.valueOf((String)ct) : null;
    }

    public URI getLocation() {
        String l = (String)this.getHeaders().getFirst((Object)"Location");
        return l != null ? URI.create(l) : null;
    }

    public EntityTag getEntityTag() {
        String t = (String)this.getHeaders().getFirst((Object)"ETag");
        return t != null ? (EntityTag)entityTagDelegate.fromString(t) : null;
    }

    public Date getLastModified() {
        String d = (String)this.getHeaders().getFirst((Object)"Last-Modified");
        return d != null ? (Date)dateDelegate.fromString(d) : null;
    }

    public Date getResponseDate() {
        String d = (String)this.getHeaders().getFirst((Object)"Date");
        return d != null ? (Date)dateDelegate.fromString(d) : null;
    }

    public String getLanguage() {
        return (String)this.getHeaders().getFirst((Object)"Content-Language");
    }

    public int getLength() {
        int size = -1;
        String sizeStr = (String)this.getHeaders().getFirst((Object)"Content-Length");
        if (sizeStr == null) {
            return -1;
        }
        try {
            size = Integer.parseInt(sizeStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return size;
    }

    public List<NewCookie> getCookies() {
        List hs = (List)this.getHeaders().get((Object)"Set-Cookie");
        if (hs == null) {
            return Collections.emptyList();
        }
        ArrayList<NewCookie> cs = new ArrayList<NewCookie>();
        for (String h : hs) {
            cs.add(NewCookie.valueOf((String)h));
        }
        return cs;
    }

    public Set<String> getAllow() {
        String allow = (String)this.headers.getFirst("Allow");
        if (allow == null) {
            return Collections.emptySet();
        }
        HashSet<String> allowedMethods = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(allow, ",");
        while (tokenizer.hasMoreTokens()) {
            String m = tokenizer.nextToken().trim();
            if (m.length() <= 0) continue;
            allowedMethods.add(m.toUpperCase());
        }
        return allowedMethods;
    }

    public WebResourceLinkHeaders getLinks() {
        return new WebResourceLinkHeaders(this.getClient(), this.getHeaders());
    }

    public String toString() {
        return "Client response status: " + this.status;
    }
}

