/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.ehcache;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.util.MemorySizeParser;
import net.sf.ehcache.util.WeakIdentityConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.util.Vm;
import org.terracotta.license.AbstractLicenseResolverFactory;
import org.terracotta.license.EnterpriseLicenseResolverFactory;
import org.terracotta.license.License;
import org.terracotta.license.LicenseException;

public class LicenseManager {
    private static final long LOG_EXPIRED_LICENSE_PERIOD = 3600000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseManager.class);
    private static final long ALLOWED_EXTRA_DIRECT_MEM = MemorySizeParser.parse("4g");
    private static final long DIRECT_MEM_OVERHEAD = MemorySizeParser.parse("256m");
    private static volatile boolean initialized;
    private static Timer expiredTimer;
    private static final AtomicInteger enterpriseManagerCount;
    private static final WeakIdentityConcurrentMap<CacheManager, Map<String, Long>> offHeapUsage;
    private static License license;

    static synchronized void init() {
        EnterpriseLicenseResolverFactory factory = new EnterpriseLicenseResolverFactory();
        license = ((AbstractLicenseResolverFactory)factory).resolveLicense();
        initialized = true;
        if (license != null) {
            LOGGER.info("Terracotta license loaded from " + ((AbstractLicenseResolverFactory)factory).getLicenseLocation() + "\n" + license.toString());
            if (license.isExpired()) {
                throw new LicenseException("Your Terracotta license has expired " + license.expirationDate());
            }
        }
    }

    public static synchronized License getLicense() {
        if (!initialized) {
            LicenseManager.init();
        }
        return license;
    }

    private static synchronized void scheduleExpiredTimerIfNeeded(Date expirationDate) {
        if (expirationDate != null && new Date().before(expirationDate)) {
            LicenseManager.killTimer();
            expiredTimer = new Timer("Licensed expired timer", true);
            long delayTime = expirationDate.getTime() - System.currentTimeMillis();
            delayTime = delayTime < 0L ? 100L : delayTime;
            expiredTimer.scheduleAtFixedRate(LicenseManager.getExpiredTimerTask(), delayTime, 3600000L);
        }
    }

    private static TimerTask getExpiredTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                LOGGER.error("Your Terracotta license has expired {}", (Object)LicenseManager.getLicense().expirationDate());
            }
        };
    }

    private static void verifyCapability(String capability) {
        LicenseManager.assertLicenseValid();
        if (!LicenseManager.getLicense().isCapabilityEnabled(capability)) {
            throw new LicenseException("Your license key doesn't allow usage of '" + capability + "' capability");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyOffHeapUsage(CacheManager cacheManager, String cacheName, long offHeapSizeDelta) {
        boolean offheapAllowed;
        long totalRequiredDirectMem;
        LicenseManager.verifyCapability("ehcache offheap");
        String licenseLimitString = LicenseManager.getLicense().getRequiredProperty("ehcache.maxOffHeap");
        long licenseLimitBytes = LicenseManager.getEhcacheOffHeapTotalSizeLimit();
        WeakIdentityConcurrentMap<CacheManager, Map<String, Long>> weakIdentityConcurrentMap = offHeapUsage;
        synchronized (weakIdentityConcurrentMap) {
            long current = LicenseManager.getCurrentOffHeapUsage(cacheManager, cacheName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("current offHeap usage is " + current + ". License limit is " + licenseLimitBytes + ". Verifying addition of " + offHeapSizeDelta);
            }
            if (current + offHeapSizeDelta > licenseLimitBytes) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(offHeapUsage.toString());
                }
                throw new LicenseException("Attempt to exceed offHeap license limit of " + licenseLimitString + " by addition of " + offHeapSizeDelta + " bytes for cache [" + cacheName + "] in cacheManager [" + cacheManager.getName() + "]");
            }
            totalRequiredDirectMem = current + offHeapSizeDelta + DIRECT_MEM_OVERHEAD;
        }
        long maxHeapFromVMInBytes = Vm.maxDirectMemory();
        if (maxHeapFromVMInBytes == Long.MAX_VALUE) {
            throw new LicenseException("No direct memory size was set at JVM level. Please set it with -XX:MaxDirectMemorySize");
        }
        if (maxHeapFromVMInBytes < totalRequiredDirectMem) {
            LOGGER.warn("Your ehcache offheap cache configuration (plus an additional " + DIRECT_MEM_OVERHEAD + " overhead) is " + totalRequiredDirectMem + " bytes. This exceeds the JVM -XX:DirectMemorySize (" + maxHeapFromVMInBytes + "). Your application may experience OutOfMemoryErrors.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("max offheap from VM: " + maxHeapFromVMInBytes);
            LOGGER.debug("max offheap allowed: " + licenseLimitBytes);
        }
        boolean bl = offheapAllowed = maxHeapFromVMInBytes <= licenseLimitBytes + ALLOWED_EXTRA_DIRECT_MEM;
        if (!offheapAllowed) {
            throw new LicenseException("Your license only allows up to " + licenseLimitString + " (+ extra " + ALLOWED_EXTRA_DIRECT_MEM + " for other use) in offheap size. Your JVM is configured with " + maxHeapFromVMInBytes + " bytes of direct memory.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("data model: " + Vm.dataModel() + "-bit");
        }
        if (Vm.dataModel() < 64) {
            LOGGER.warn("Your JVM seems to be running with a 32-bit data model. If you get OutOfMemoryError it could be that it is running out of process space. Please see the documentation for further information on configuring OffHeapStore with 32-bit JVMs.");
        }
        LicenseManager.afterVerified(cacheManager);
    }

    public static void verifyWanReplication(TerracottaClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("Terracotta client configuration is not defined");
        }
        if (config.isWanEnabledTSA()) {
            LicenseManager.verifyCapability("WAN");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeCacheOffHeapUsage(CacheManager cacheManager, String cacheName) {
        WeakIdentityConcurrentMap<CacheManager, Map<String, Long>> weakIdentityConcurrentMap = offHeapUsage;
        synchronized (weakIdentityConcurrentMap) {
            Map<String, Long> map = offHeapUsage.get(cacheManager);
            if (map != null) {
                map.remove(cacheName);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("clearing offHeap usage for " + cacheManager.getName() + ", " + cacheName + ". Usage is now " + LicenseManager.getCurrentOffHeapUsage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commitOffHeapUsage(CacheManager cacheManager, String cacheName, long usage) {
        if (usage < 0L) {
            throw new IllegalArgumentException("delta must be positive: " + usage);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("committing " + usage + " additional offHeap bytes for " + cacheManager.getName() + ", " + cacheName);
        }
        WeakIdentityConcurrentMap<CacheManager, Map<String, Long>> weakIdentityConcurrentMap = offHeapUsage;
        synchronized (weakIdentityConcurrentMap) {
            Map<String, Long> map = offHeapUsage.get(cacheManager);
            if (map == null) {
                map = new HashMap<String, Long>();
                offHeapUsage.put(cacheManager, map);
            }
            map.put(cacheName, usage);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("after commit usage is " + LicenseManager.getCurrentOffHeapUsage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearOffHeapUsage(CacheManager cacheManager) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("clearing offHeap usage for " + cacheManager.getName());
        }
        WeakIdentityConcurrentMap<CacheManager, Map<String, Long>> weakIdentityConcurrentMap = offHeapUsage;
        synchronized (weakIdentityConcurrentMap) {
            offHeapUsage.remove(cacheManager);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("after clearing for " + cacheManager.getName() + ", usage is " + LicenseManager.getCurrentOffHeapUsage());
            }
        }
    }

    public static long getCurrentOffHeapUsage() {
        return LicenseManager.getCurrentOffHeapUsage(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getCurrentOffHeapUsage(CacheManager excludeCacheMgr, String excludeCacheName) {
        WeakIdentityConcurrentMap<CacheManager, Map<String, Long>> weakIdentityConcurrentMap = offHeapUsage;
        synchronized (weakIdentityConcurrentMap) {
            long total = 0L;
            for (CacheManager cm : offHeapUsage.keySet()) {
                for (Map.Entry<String, Long> entry : offHeapUsage.get(cm).entrySet()) {
                    if (cm == excludeCacheMgr && LicenseManager.eq(entry.getKey(), excludeCacheName)) continue;
                    total += entry.getValue().longValue();
                }
            }
            return total;
        }
    }

    private static boolean eq(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private static synchronized void afterVerified(CacheManager cacheManager) {
        CacheManagerEventListenerRegistry registry = cacheManager.getCacheManagerEventListenerRegistry();
        Listener listener = new Listener(cacheManager);
        if (!registry.getRegisteredListeners().contains(listener)) {
            registry.registerListener(listener);
            if (enterpriseManagerCount.getAndIncrement() == 0) {
                LicenseManager.scheduleExpiredTimerIfNeeded(LicenseManager.getLicense().expirationDate());
            }
        }
    }

    public static void assertLicenseValid() {
        if (LicenseManager.getLicense() == null) {
            throw new LicenseException("Terracotta license key is required for Enterprise capabilities. Please place terracotta-license.key in Terracotta installed directory or in resource path. You could also specify it through system property -Dcom.tc.productkey.path=/path/to/key");
        }
        Date expirationDate = LicenseManager.getLicense().expirationDate();
        if (expirationDate != null && expirationDate.before(new Date())) {
            throw new LicenseException("Your Terracotta license has expired on " + expirationDate);
        }
    }

    private static synchronized void killTimer() {
        if (expiredTimer != null) {
            expiredTimer.cancel();
            expiredTimer = null;
        }
    }

    public static long getEhcacheOffHeapTotalSizeLimit() {
        String maxHeapSizeFromLicense = LicenseManager.getLicense().getRequiredProperty("ehcache.maxOffHeap");
        return MemorySizeParser.parse(maxHeapSizeFromLicense);
    }

    static {
        enterpriseManagerCount = new AtomicInteger(0);
        offHeapUsage = new WeakIdentityConcurrentMap();
    }

    private static class Listener
    implements CacheManagerEventListener {
        private final CacheManager manager;

        Listener(CacheManager manager) {
            this.manager = manager;
        }

        @Override
        public void init() throws CacheException {
        }

        @Override
        public Status getStatus() {
            return null;
        }

        @Override
        public void dispose() throws CacheException {
            if (enterpriseManagerCount.decrementAndGet() == 0) {
                LicenseManager.killTimer();
            }
            LicenseManager.clearOffHeapUsage(this.manager);
        }

        @Override
        public void notifyCacheAdded(String cacheName) {
        }

        @Override
        public void notifyCacheRemoved(String cacheName) {
            LicenseManager.removeCacheOffHeapUsage(this.manager, cacheName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Listener) {
                return ((Listener)obj).manager == this.manager;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.manager);
        }
    }
}

