/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta.security;

import java.io.Console;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.terracotta.toolkit.SecretProvider;

public class ConsoleFetchingSecretProvider
implements SecretProvider {
    private final Object lock = new Object();
    private byte[] secret;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSecret() {
        Object object = this.lock;
        synchronized (object) {
            return this.secret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchSecret() {
        Object object = this.lock;
        synchronized (object) {
            if (this.secret == null) {
                Console console = System.console();
                if (console == null) {
                    throw new IllegalStateException("Couldn't access a Console instance to fetch the password from!");
                }
                this.secret = ConsoleFetchingSecretProvider.toBytesAndWipe(console.readPassword("Enter secret to key store: ", new Object[0]));
            }
        }
    }

    public static byte[] toBytesAndWipe(char[] secret) {
        if (secret == null) {
            return null;
        }
        ByteBuffer source = Charset.forName("UTF-8").encode(CharBuffer.wrap(secret));
        byte[] array = new byte[source.remaining()];
        System.arraycopy(source.array(), 0, array, 0, array.length);
        Arrays.fill(secret, '\u0000');
        return array;
    }
}

