/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk.persistent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.store.offheap.disk.EhcachePersistentConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;

public class OffHeapPersistentDiskStore
extends OffHeapDiskStore {
    private final File indexFile;

    public OffHeapPersistentDiskStore(File dataFile, File indexFile, EhcachePersistentConcurrentOffHeapClockCache map, RegisteredEventListeners eventService, Pool onDiskPool, Ehcache cache, LuceneIndexedSearchManager searchManager) {
        super(dataFile, map, eventService, onDiskPool, cache, searchManager);
        this.indexFile = indexFile;
    }

    @Override
    public synchronized void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            try {
                this.map.flush();
                this.persist();
                this.map.close();
                this.onDiskPoolAccessor.unlink();
            }
            catch (IOException e) {
                throw new CacheException("Failed to cleanly dispose the disk store", e);
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.map.flush();
        this.persist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void persist() throws IOException {
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.indexFile));
        try {
            output.writeLong(System.currentTimeMillis());
            this.map.persist(output);
        }
        finally {
            output.close();
        }
    }
}

