/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.buffersource;

import com.terracottatech.offheapstore.buffersource.BufferSource;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffHeapBufferSource
implements BufferSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapBufferSource.class);

    @Override
    public ByteBuffer allocateBuffer(int size) {
        try {
            return ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError e) {
            LOGGER.debug("Failed to allocate " + size + " byte offheap buffer", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "Off-Heap Buffer Source";
    }
}

