/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.terracotta.shaded.lucene.index.BufferedUpdates;
import org.terracotta.shaded.lucene.index.BufferedUpdatesStream;
import org.terracotta.shaded.lucene.index.NumericUpdate;
import org.terracotta.shaded.lucene.index.PrefixCodedTerms;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.util.ArrayUtil;
import org.terracotta.shaded.lucene.util.RamUsageEstimator;

class FrozenBufferedUpdates {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms terms;
    int termCount;
    final Query[] queries;
    final int[] queryLimits;
    final NumericUpdate[] updates;
    final int bytesUsed;
    final int numTermDeletes;
    private long gen = -1L;
    final boolean isSegmentPrivate;

    public FrozenBufferedUpdates(BufferedUpdates deletes, boolean isSegmentPrivate) {
        this.isSegmentPrivate = isSegmentPrivate;
        assert (!isSegmentPrivate || deletes.terms.size() == 0) : "segment private package should only have del queries";
        Comparable[] termsArray = deletes.terms.keySet().toArray(new Term[deletes.terms.size()]);
        this.termCount = termsArray.length;
        ArrayUtil.timSort((Comparable[])termsArray);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        for (Comparable term : termsArray) {
            builder.add((Term)term);
        }
        this.terms = builder.finish();
        this.queries = new Query[deletes.queries.size()];
        this.queryLimits = new int[deletes.queries.size()];
        int upto = 0;
        for (Map.Entry<Query, Integer> ent : deletes.queries.entrySet()) {
            this.queries[upto] = ent.getKey();
            this.queryLimits[upto] = ent.getValue();
            ++upto;
        }
        ArrayList<NumericUpdate> allUpdates = new ArrayList<NumericUpdate>();
        int numericUpdatesSize = 0;
        for (LinkedHashMap<Term, NumericUpdate> fieldUpdates : deletes.numericUpdates.values()) {
            for (NumericUpdate update : fieldUpdates.values()) {
                allUpdates.add(update);
                numericUpdatesSize += update.sizeInBytes();
            }
        }
        this.updates = allUpdates.toArray(new NumericUpdate[allUpdates.size()]);
        this.bytesUsed = (int)this.terms.getSizeInBytes() + this.queries.length * BYTES_PER_DEL_QUERY + numericUpdatesSize + this.updates.length * RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        this.numTermDeletes = deletes.numTermDeletes.get();
    }

    public void setDelGen(long gen) {
        assert (this.gen == -1L);
        this.gen = gen;
    }

    public long delGen() {
        assert (this.gen != -1L);
        return this.gen;
    }

    public Iterable<Term> termsIterable() {
        return new Iterable<Term>(){

            @Override
            public Iterator<Term> iterator() {
                return FrozenBufferedUpdates.this.terms.iterator();
            }
        };
    }

    public Iterable<BufferedUpdatesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedUpdatesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedUpdatesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedUpdatesStream.QueryAndLimit>(){
                    private int upto;

                    @Override
                    public boolean hasNext() {
                        return this.upto < FrozenBufferedUpdates.this.queries.length;
                    }

                    @Override
                    public BufferedUpdatesStream.QueryAndLimit next() {
                        BufferedUpdatesStream.QueryAndLimit ret = new BufferedUpdatesStream.QueryAndLimit(FrozenBufferedUpdates.this.queries[this.upto], FrozenBufferedUpdates.this.queryLimits[this.upto]);
                        ++this.upto;
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        String s = "";
        if (this.numTermDeletes != 0) {
            s = s + " " + this.numTermDeletes + " deleted terms (unique count=" + this.termCount + ")";
        }
        if (this.queries.length != 0) {
            s = s + " " + this.queries.length + " deleted queries";
        }
        if (this.bytesUsed != 0) {
            s = s + " bytesUsed=" + this.bytesUsed;
        }
        return s;
    }

    boolean any() {
        return this.termCount > 0 || this.queries.length > 0 || this.updates.length > 0;
    }
}

