/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.terracotta.shaded.lucene.index.BufferedUpdates;
import org.terracotta.shaded.lucene.index.BufferedUpdatesStream;
import org.terracotta.shaded.lucene.index.FrozenBufferedUpdates;
import org.terracotta.shaded.lucene.index.NumericUpdate;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.util.MergedIterator;

class CoalescedUpdates {
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<Iterable<Term>> iterables = new ArrayList<Iterable<Term>>();
    final List<NumericUpdate> numericDVUpdates = new ArrayList<NumericUpdate>();

    CoalescedUpdates() {
    }

    public String toString() {
        return "CoalescedUpdates(termSets=" + this.iterables.size() + ",queries=" + this.queries.size() + ",numericUpdates=" + this.numericDVUpdates.size() + ")";
    }

    void update(FrozenBufferedUpdates in) {
        this.iterables.add(in.termsIterable());
        for (int queryIdx = 0; queryIdx < in.queries.length; ++queryIdx) {
            Query query = in.queries[queryIdx];
            this.queries.put(query, BufferedUpdates.MAX_INT);
        }
        for (NumericUpdate nu : in.updates) {
            NumericUpdate clone = new NumericUpdate(nu.term, nu.field, nu.value);
            clone.docIDUpto = Integer.MAX_VALUE;
            this.numericDVUpdates.add(clone);
        }
    }

    public Iterable<Term> termsIterable() {
        return new Iterable<Term>(){

            @Override
            public Iterator<Term> iterator() {
                Iterator[] subs = new Iterator[CoalescedUpdates.this.iterables.size()];
                for (int i = 0; i < CoalescedUpdates.this.iterables.size(); ++i) {
                    subs[i] = CoalescedUpdates.this.iterables.get(i).iterator();
                }
                return new MergedIterator<Term>(subs);
            }
        };
    }

    public Iterable<BufferedUpdatesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedUpdatesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedUpdatesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedUpdatesStream.QueryAndLimit>(){
                    private final Iterator<Map.Entry<Query, Integer>> iter;
                    {
                        this.iter = CoalescedUpdates.this.queries.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public BufferedUpdatesStream.QueryAndLimit next() {
                        Map.Entry<Query, Integer> ent = this.iter.next();
                        return new BufferedUpdatesStream.QueryAndLimit(ent.getKey(), ent.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

