/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.search;

import net.sf.ehcache.Element;
import net.sf.ehcache.ElementData;
import net.sf.ehcache.search.impl.ResultImpl;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.transaction.SoftLockID;
import org.terracotta.modules.ehcache.store.ValueModeHandler;
import org.terracotta.toolkit.search.SearchResult;

public class ClusteredResultImpl
extends ResultImpl {
    private final ValueModeHandler valueModeHandler;
    private final SearchResult result;
    private volatile Object resolvedValue;

    public ClusteredResultImpl(ValueModeHandler valueModeHandler, SearchResult result, StoreQuery query) {
        super(query.requestsKeys() ? valueModeHandler.getRealKeyObject(result.getKey()) : null, null, query, result.getAttributes(), result.getSortAttributes());
        this.valueModeHandler = valueModeHandler;
        this.result = result;
        this.setAggregateResults(result.getAggregatorResults());
    }

    @Override
    protected Object basicGetValue() {
        Element e;
        if (this.resolvedValue != null) {
            return this.resolvedValue;
        }
        ElementData elementData = (ElementData)this.result.getValue();
        if (elementData == null) {
            return null;
        }
        if (elementData.getValue() instanceof SoftLockID) {
            e = ((SoftLockID)elementData.getValue()).getOldElement();
            if (e == null) {
                throw new IllegalStateException("No previously committed value exists for indexed transactional put, key=" + this.getKey());
            }
        } else {
            e = this.valueModeHandler.createElement(null, elementData);
        }
        this.resolvedValue = e.getObjectValue();
        return this.resolvedValue;
    }
}

