/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RegisterableObjectManager;
import java.nio.ByteBuffer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.store.restartability.EhcacheRestartability;

public class EhcacheObjectManager
extends RegisterableObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> {
    @Override
    public void replayPut(ByteBuffer id, ByteBuffer key, ByteBuffer value, long lsn) {
        ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> stripe = this.getStripeFor(id);
        if (stripe == null) {
            if (EhcacheRestartability.isPinningIdentifier(id)) {
                throw new CacheException("Unexpected pinning data for cache " + EhcacheRestartability.getCacheNameFor(id));
            }
            if (EhcacheRestartability.isCacheIdentifier(id)) {
                throw new CacheException("Unexpected data for cache " + EhcacheRestartability.getCacheNameFor(id) + " (this may be due to a corrupted metadata log)");
            }
            if (EhcacheRestartability.isWriteBehindIdentifier(id)) {
                throw new CacheException("Unexpected data for write-behind queue " + EhcacheRestartability.getCacheNameFor(id));
            }
            if (EhcacheRestartability.isSoftLockIdentifier(id)) {
                throw new CacheException("Unexpected soft-lock data for cache " + EhcacheRestartability.getCacheNameFor(id));
            }
            throw new IllegalStateException("Unexpected identifier : " + id.asCharBuffer().toString());
        }
        stripe.replayPut(key, value, lsn);
    }
}

