/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.PersistentReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.CacheOperationOutcomes;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;
import org.terracotta.statistics.observer.OperationObserver;

public class EhcachePersistentSegmentFactory
implements Factory<Segment<Serializable, Element>> {
    private final RegisteredEventListeners evictionListener;
    private final OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver;
    private final Factory<? extends PersistentStorageEngine<? super Serializable, ? super Element>> storageEngineFactory;
    private final MappedPageSource tableSource;
    private final int tableSize;
    private final boolean bootstrap;
    private final AtomicLong size = new AtomicLong();
    private final long capacity;

    public EhcachePersistentSegmentFactory(RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, MappedPageSource source, Factory<? extends PersistentStorageEngine<? super Serializable, ? super Element>> storageEngineFactory, int initialTableSize, long capacity, boolean bootstrap) {
        this.evictionListener = evictionListener;
        this.evictionObserver = evictionObserver;
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.bootstrap = bootstrap;
        this.capacity = capacity;
    }

    @Override
    public EhcachePersistentSegment newInstance() {
        PersistentStorageEngine<? super Serializable, ? super Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            if (this.capacity > 0L) {
                return new EhcachePersistentSegment(this.evictionListener, this.evictionObserver, this.tableSource, storageEngine, this.tableSize, this.size, this.capacity, this.bootstrap);
            }
            return new EhcachePersistentSegment(this.evictionListener, this.evictionObserver, this.tableSource, storageEngine, this.tableSize, this.bootstrap);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class EhcachePersistentSegment
    extends PersistentReadWriteLockedOffHeapClockCache<Serializable, Element> {
        private final RegisteredEventListeners evictionListener;
        private final OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver;
        private final AtomicLong globalSize;
        private final long globalCapacity;

        EhcachePersistentSegment(RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, MappedPageSource source, PersistentStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, AtomicLong size, long capacity, boolean bootstrap) {
            super(source, storageEngine, tableSize, bootstrap);
            this.evictionListener = evictionListener;
            this.evictionObserver = evictionObserver;
            this.globalSize = size;
            this.globalCapacity = capacity;
        }

        EhcachePersistentSegment(RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionOutcome, MappedPageSource source, PersistentStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean bootstrap) {
            this(evictionListener, evictionOutcome, source, storageEngine, tableSize, new AtomicLong(), Long.MAX_VALUE, bootstrap);
        }

        @Override
        protected void added(int position) {
            super.added(position);
            long currentSize = this.globalSize.incrementAndGet();
            long evict = Math.min(currentSize - this.globalCapacity, 2L);
            block0: for (long i = 0L; i < evict; ++i) {
                int evictionIndex;
                for (int j = 0; j < 3 && (evictionIndex = this.getEvictionIndex()) >= 0; ++j) {
                    if (evictionIndex == position) continue;
                    this.evict(evictionIndex, false);
                    continue block0;
                }
            }
        }

        @Override
        protected void removed(int position) {
            super.removed(position);
            this.globalSize.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evict(int index, boolean shrink) {
            Lock l = this.writeLock();
            l.lock();
            try {
                this.evictInternal(index, shrink);
                boolean bl = true;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Element evict() {
            Lock l = this.writeLock();
            if (l.tryLock()) {
                try {
                    int index = this.getEvictionIndex();
                    if (index < 0) {
                        Element element = null;
                        return element;
                    }
                    Element element = this.evictInternal(index, false);
                    return element;
                }
                finally {
                    l.unlock();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Element evictInternal(int index, boolean shrink) {
            try {
                Element e = (Element)this.getAtTableOffset(index);
                this.evictionListener.notifyElementRemovedOrdered(e);
                if (this.evictionListener.hasCacheEventListeners()) {
                    if (e.isExpired()) {
                        this.evictionListener.notifyElementExpiry(e, false);
                    } else {
                        this.evictionListener.notifyElementEvicted(e, false);
                    }
                }
                Element element = e;
                return element;
            }
            finally {
                this.evictionObserver.begin();
                super.evict(index, shrink);
                this.evictionObserver.end(CacheOperationOutcomes.EvictionOutcome.SUCCESS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object key, Element value, ElementValueComparator comparator) {
            Lock l = this.writeLock();
            l.lock();
            try {
                if (key == null) {
                    throw new NullPointerException();
                }
                if (value == null) {
                    boolean bl = false;
                    return bl;
                }
                Element existing = (Element)super.get(key);
                if (comparator.equals(value, existing)) {
                    this.remove(key);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
            Lock l = this.writeLock();
            l.lock();
            try {
                Element existing = (Element)this.get(key);
                if (comparator.equals(oldValue, existing)) {
                    this.put(key, newValue);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element put(Serializable key, Element value, int metadata) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Element oldElement = super.put(key, value, metadata);
                if (oldElement != null) {
                    this.evictionListener.notifyElementRemovedOrdered(oldElement);
                }
                this.evictionListener.notifyElementPutOrdered(value);
                Element element = oldElement;
                return element;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element remove(Object key) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Element oldElement = (Element)super.remove(key);
                if (oldElement != null) {
                    this.evictionListener.notifyElementRemovedOrdered(oldElement);
                }
                Element element = oldElement;
                return element;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

