/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.AbstractAggregator;
import com.terracottatech.search.aggregator.DoubleAverage;
import com.terracottatech.search.aggregator.EmptyAverage;
import com.terracottatech.search.aggregator.FloatAverage;
import com.terracottatech.search.aggregator.IntegerAverage;
import com.terracottatech.search.aggregator.LongAverage;

public abstract class Average
extends AbstractAggregator {
    public Average(String attributeName, ValueType type) {
        super(AggregatorOperations.AVERAGE, attributeName, type);
    }

    public static Average average(String attributeName, ValueType type) throws IllegalArgumentException {
        if (type == null) {
            return new EmptyAverage(attributeName);
        }
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return new IntegerAverage(attributeName, type);
            }
            case LONG: {
                return new LongAverage(attributeName, type);
            }
            case FLOAT: {
                return new FloatAverage(attributeName, type);
            }
            case DOUBLE: {
                return new DoubleAverage(attributeName, type);
            }
        }
        throw new IllegalArgumentException("Attribute [" + attributeName + ":" + (Object)((Object)type) + "] is not a numeric type");
    }
}

