/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.CachedDocIdResultSource;
import com.terracottatech.search.Configuration;
import com.terracottatech.search.CustomMultiReader;
import com.terracottatech.search.DeferredQueryResult;
import com.terracottatech.search.GroupedIndexQueryResultImpl;
import com.terracottatech.search.GroupedQueryResult;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.IndexOwner;
import com.terracottatech.search.IndexQueryResult;
import com.terracottatech.search.IndexQueryResultImpl;
import com.terracottatech.search.Logger;
import com.terracottatech.search.LoggerFactory;
import com.terracottatech.search.LuceneIndex;
import com.terracottatech.search.LuceneIndexManager;
import com.terracottatech.search.LuceneQueryBuilder;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.NonGroupedIndexQueryResultImpl;
import com.terracottatech.search.NonGroupedQueryResult;
import com.terracottatech.search.QueryID;
import com.terracottatech.search.QueryInputs;
import com.terracottatech.search.QueryResultComparator;
import com.terracottatech.search.ResultTools;
import com.terracottatech.search.SearchResult;
import com.terracottatech.search.SearchResultSource;
import com.terracottatech.search.SearchResultSourceFactory;
import com.terracottatech.search.SortFieldProvider;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.AbstractAggregator;
import com.terracottatech.search.aggregator.Aggregator;
import com.terracottatech.search.aggregator.Count;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.terracotta.shaded.lucene.document.Document;
import org.terracotta.shaded.lucene.index.AtomicReaderContext;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.index.MultiReader;
import org.terracotta.shaded.lucene.search.Collector;
import org.terracotta.shaded.lucene.search.IndexSearcher;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.search.Scorer;

final class SearchResultsManager {
    private final IndexOwner parent;
    private final SearchResultSourceFactory pagedResultSourceFactory;
    private final int maxOpenCursors;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Logger log;
    private final ExecutorService execSvc;
    private static final String COUNT_AGG_NAME = "__TC_AGG_COUNT" + SearchResultsManager.class.hashCode();
    private final ConcurrentMap<QueryID, SearchResultSource> resultSources = new ConcurrentHashMap<QueryID, SearchResultSource>();

    SearchResultsManager(File dataPath, final IndexOwner owner, Configuration globalConfig, ExecutorService svc, LoggerFactory loggerFactory) {
        this.pagedResultSourceFactory = new SearchResultSourceFactory(globalConfig, dataPath).setLoggerFactory(loggerFactory).setIndexOwner(new IndexOwner(){

            @Override
            public Map<String, LuceneIndexManager.AttributeProperties> getSchema() {
                return Collections.emptyMap();
            }

            @Override
            public Timer getReaderRefreshTimer() {
                return owner.getReaderRefreshTimer();
            }

            @Override
            public void checkSchema(List<NVPair> attributes, boolean indexed) {
            }
        });
        this.maxOpenCursors = globalConfig.getMaxOpenResultSets();
        this.parent = owner;
        this.log = loggerFactory.getLogger(SearchResultsManager.class);
        this.execSvc = svc;
    }

    void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            for (SearchResultSource resSrc : this.resultSources.values()) {
                try {
                    resSrc.close();
                }
                catch (IOException e) {
                    this.log.error("Error closing result source", e);
                }
            }
            this.resultSources.clear();
        }
    }

    private static List<NVPair> loadSortFields(Document doc, QueryInputs inputs) {
        Map<String, ValueType> types = inputs.getFieldSchema();
        List<NVPair> sortParams = inputs.getSortAttributes();
        ArrayList<NVPair> sortFields = new ArrayList<NVPair>(sortParams.size());
        for (NVPair pair : sortParams) {
            String sortAttrKey = pair.getName();
            ValueType type = types.get(sortAttrKey);
            Object attrValue = LuceneIndex.getFieldValue(doc, sortAttrKey, type);
            NVPair attributePair = AbstractNVPair.createNVPair(sortAttrKey, attrValue, type);
            sortFields.add(attributePair);
        }
        return sortFields;
    }

    static void loadDocumentData(Document doc, QueryInputs searchParams, List<NVPair> attributeValues, Set<NVPair> groupByValues, List<NVPair> sortValues) {
        Object attrValue;
        ValueType type;
        Map<String, ValueType> types = searchParams.getFieldSchema();
        for (String attrKey : searchParams.getAttributes()) {
            type = types.get(attrKey);
            attrValue = LuceneIndex.getFieldValue(doc, attrKey, type);
            attributeValues.add(AbstractNVPair.createNVPair(attrKey, attrValue, type));
        }
        for (String attrKey : searchParams.getGroupByAttributes()) {
            type = types.get(attrKey);
            attrValue = LuceneIndex.getFieldValue(doc, attrKey, type);
            groupByValues.add(AbstractNVPair.createNVPair(attrKey, attrValue, type));
        }
        sortValues.addAll(SearchResultsManager.loadSortFields(doc, searchParams));
    }

    void clearResultsFor(final long requesterId) throws IndexException {
        this.cleanupResults(new ResultsFilter(){

            @Override
            public boolean accept(QueryID resId) {
                return requesterId != resId.requesterId;
            }
        });
    }

    void pruneResults(final Set<Long> activeClients) throws IndexException {
        this.cleanupResults(new ResultsFilter(){

            @Override
            public boolean accept(QueryID resId) {
                return activeClients.contains(resId.requesterId);
            }
        });
    }

    void resultsProcessed(QueryID id) throws IndexException {
        SearchResultSource results = (SearchResultSource)this.resultSources.remove(id);
        if (results == null) {
            this.log.debug("Result source does not exist for query id: " + id);
            return;
        }
        if (results == SearchResultSource.NULL_SOURCE) {
            throw new IndexException("Attempting to release search results for query still in execution: " + id);
        }
        try {
            results.close();
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    SearchResult loadResults(long requesterId, long queryId, int offset, int batchLimit) throws IndexException {
        if (this.shutdown.get()) {
            throw new IndexException("Already closed.");
        }
        QueryID id = new QueryID(requesterId, queryId);
        SearchResultSource src = (SearchResultSource)this.resultSources.get(id);
        if (src == null) {
            return null;
        }
        if (src == SearchResultSource.NULL_SOURCE) {
            throw new IndexException(String.format("Results for query %s not (yet) available", id));
        }
        return src.getResults(offset, batchLimit);
    }

    SearchResult executeQuery(QueryID id, List queryStack, IndexReader[] readers, final boolean includeKeys, final boolean includeValues, Set<String> attributeSet, final Set<String> groupByAttributes, final List<NVPair> sortAttributes, List<NVPair> aggPairs, int resultLimit, int batchLimit) throws IndexException {
        SearchResultSource old;
        if (this.shutdown.get()) {
            throw new IndexException("Already closed.");
        }
        boolean isSorted = !sortAttributes.isEmpty();
        boolean isPagedSearch = batchLimit != -1;
        SearchResultSource searchResultSource = old = isPagedSearch ? this.resultSources.putIfAbsent(id, SearchResultSource.NULL_SOURCE) : null;
        if (old != null) {
            throw new IndexException("Query id already in use: " + id);
        }
        CustomMultiReader dataReader = new CustomMultiReader(readers);
        try {
            SearchResult<Object> reply;
            DocIdList docIds;
            boolean isGroupBy;
            if (isPagedSearch && this.maxOpenCursors > 0 && this.resultSources.size() > this.maxOpenCursors) {
                throw new IndexException(String.format("Max open cursor limit reached: %d, offending query: %s", this.maxOpenCursors, id));
            }
            final Query searchQuery = new LuceneQueryBuilder(queryStack, this.parent.getSchema()).buildQuery();
            boolean bl = isGroupBy = !groupByAttributes.isEmpty();
            if (isGroupBy) {
                resultLimit = -1;
            }
            SearchResultSource source = null;
            Map<String, List<Aggregator>> aggsPerAttr = this.createAggregators(aggPairs);
            HashSet<String> aggregatorFields = new HashSet<String>(aggsPerAttr.keySet());
            boolean includeCount = aggregatorFields.remove(COUNT_AGG_NAME);
            ArrayList<Object> firstBatch = new ArrayList();
            final HashMap<String, ValueType> requestedFields = new HashMap<String, ValueType>();
            final HashSet<String> reqFieldNames = new HashSet<String>();
            for (String string : attributeSet) {
                reqFieldNames.add(string);
            }
            for (String string : groupByAttributes) {
                reqFieldNames.add(string);
            }
            for (NVPair nVPair : sortAttributes) {
                reqFieldNames.add(nVPair.getName());
            }
            for (String string : aggregatorFields) {
                reqFieldNames.add(string);
            }
            for (String string : reqFieldNames) {
                requestedFields.put(string, this.getTypeForAttribute(string));
            }
            if (includeKeys) {
                reqFieldNames.add("__TC_KEY_FIELD");
            }
            if (includeValues) {
                reqFieldNames.add("__TC_VALUE_FIELD");
            }
            final HashSet<String> reqAttributes = new HashSet<String>(attributeSet);
            if (resultLimit > 0) {
                reqAttributes.addAll(aggregatorFields);
            }
            QueryInputs queryInputs = new QueryInputs(){

                @Override
                public boolean includeValues() {
                    return includeValues;
                }

                @Override
                public boolean includeKeys() {
                    return includeKeys;
                }

                @Override
                public List<NVPair> getSortAttributes() {
                    return sortAttributes;
                }

                @Override
                public Set<String> getGroupByAttributes() {
                    return groupByAttributes;
                }

                @Override
                public Set<String> getFieldNamesToLoad() {
                    return reqFieldNames;
                }

                @Override
                public Set<String> getAttributes() {
                    return reqAttributes;
                }

                @Override
                public Map<String, ValueType> getFieldSchema() {
                    return requestedFields;
                }
            };
            HashMap<Set<NVPair>, GroupedQueryResult> uniqueGroups = new HashMap<Set<NVPair>, GroupedQueryResult>();
            if (resultLimit == 0) {
                docIds = new EmptyDocIdList();
            } else {
                SimpleCollector[] collectors = new SimpleCollector[readers.length];
                ArrayList<5> searchTasks = new ArrayList<5>(readers.length);
                for (int i = 0; i < readers.length; ++i) {
                    SimpleCollector c;
                    final IndexReader r = readers[i];
                    collectors[i] = c = new SimpleCollector(queryInputs, dataReader.getBase(i), resultLimit);
                    searchTasks.add(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            IndexSearcher searcher = new IndexSearcher(r);
                            searcher.search(searchQuery, c);
                            return null;
                        }
                    });
                }
                this.execSvc.invokeAll(searchTasks);
                CompositeCollector merger = new CompositeCollector(dataReader, queryInputs, resultLimit);
                for (SimpleCollector collector : collectors) {
                    merger.combine(collector.getDocIds());
                }
                merger.sort();
                merger.truncateIfNeeded();
                docIds = merger;
            }
            int resultCount = 0;
            for (int i = 0; i < docIds.size(); ++i) {
                IndexQueryResultImpl result;
                int docId = docIds.get(i);
                Document doc = dataReader.document(docId, reqFieldNames);
                ArrayList<NVPair> attributes = new ArrayList<NVPair>(reqAttributes.size());
                Set groupByAttrs = isGroupBy ? new HashSet(groupByAttributes.size()) : Collections.EMPTY_SET;
                List sortAttributesList = sortAttributes.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(sortAttributes.size());
                ArrayList<NVPair> aggregators = aggregatorFields.isEmpty() ? Collections.emptyList() : new ArrayList<NVPair>(aggregatorFields.size());
                SearchResultsManager.loadDocumentData(doc, queryInputs, attributes, groupByAttrs, sortAttributesList);
                for (String attrKey : aggregatorFields) {
                    ValueType type = (ValueType)((Object)requestedFields.get(attrKey));
                    Object attrValue = LuceneIndex.getFieldValue(doc, attrKey, type);
                    aggregators.add(AbstractNVPair.createNVPair(attrKey, attrValue, type));
                }
                if (isGroupBy) {
                    result = new GroupedIndexQueryResultImpl(attributes, sortAttributesList, groupByAttrs, new ArrayList<Aggregator>());
                    this.putInGroup(result, aggregators, uniqueGroups, aggsPerAttr);
                    continue;
                }
                if (includeCount) {
                    Collection countAggs = aggsPerAttr.get(COUNT_AGG_NAME);
                    if (countAggs.isEmpty()) {
                        throw new AssertionError((Object)"Count aggregator: expected non-empty singleton list");
                    }
                    Count count = (Count)countAggs.iterator().next();
                    count.accept(docId);
                }
                for (NVPair attr : aggregators) {
                    Collection attrAggs = aggsPerAttr.get(attr.getName());
                    if (attrAggs == null) {
                        throw new AssertionError();
                    }
                    for (Aggregator aggregator : attrAggs) {
                        try {
                            aggregator.accept(ValueType.ENUM == attr.getType() ? AbstractNVPair.enumStorageString((AbstractNVPair.EnumNVPair)attr) : attr.getObjectValue());
                        }
                        catch (IllegalArgumentException e) {
                            throw new IndexException(e);
                        }
                    }
                }
                if (!includeKeys && !includeValues && attributes.isEmpty()) continue;
                String key = includeKeys ? doc.get("__TC_KEY_FIELD") : null;
                ValueID value = includeValues ? (ValueID)LuceneIndex.getFieldValue(doc, "__TC_VALUE_FIELD", ValueType.VALUE_ID) : ValueID.NULL_ID;
                result = new NonGroupedIndexQueryResultImpl(key, value, attributes, sortAttributesList);
                DeferredQueryResult toSave = new DeferredQueryResult((NonGroupedQueryResult)((Object)result), docId);
                if (firstBatch.size() == batchLimit) {
                    if (source == null) {
                        source = this.pagedResultSourceFactory.createSource(dataReader, queryInputs, docIds.size());
                        for (IndexQueryResult indexQueryResult : firstBatch) {
                            source.acceptResult((DeferredQueryResult)indexQueryResult);
                        }
                    }
                    if (source instanceof CachedDocIdResultSource && aggPairs.isEmpty()) {
                        for (int n = i; n < docIds.size(); ++n) {
                            DeferredQueryResult deferredQueryResult = new DeferredQueryResult(null, docIds.get(n));
                            ++resultCount;
                            source.acceptResult(deferredQueryResult);
                        }
                        break;
                    }
                    source.acceptResult(toSave);
                } else {
                    firstBatch.add(toSave);
                }
                ++resultCount;
            }
            if (isGroupBy) {
                ArrayList groups = new ArrayList(uniqueGroups.values());
                if (isSorted) {
                    Collections.sort(groups, new QueryResultComparator(sortAttributes));
                }
                firstBatch = groups;
                resultCount = firstBatch.size();
                reply = new SearchResult<Object>(resultCount, firstBatch, Collections.EMPTY_LIST, docIds.size() > 0);
            } else {
                ArrayList<Aggregator> destAggs = new ArrayList<Aggregator>();
                for (List<Aggregator> attrAggs : aggsPerAttr.values()) {
                    destAggs.addAll(attrAggs);
                }
                reply = new SearchResult<Object>(resultCount, firstBatch, destAggs, docIds.size() > 0);
            }
            if (!aggPairs.isEmpty()) {
                this.reorderAggregators(aggPairs, isGroupBy, reply);
            }
            if (isGroupBy) {
                this.resultSources.remove(id);
            } else if (source == null) {
                this.resultSources.remove(id);
            } else {
                source.setAggregatorValues(reply.getAggregators());
                this.resultSources.put(id, source);
            }
            try {
                if (source == null) {
                    dataReader.close();
                }
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
            return reply;
        }
        catch (Exception t) {
            SearchResultSource resSource = (SearchResultSource)this.resultSources.remove(id);
            if (resSource != null && resSource != SearchResultSource.NULL_SOURCE) {
                try {
                    resSource.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.log.error("Query execution terminated abnormally", t);
            throw t instanceof IndexException ? (IndexException)t : new IndexException(t);
        }
    }

    private void putInGroup(IndexQueryResult res, Collection<NVPair> resultAggs, Map<Set<NVPair>, GroupedQueryResult> uniqueGroups, Map<String, List<Aggregator>> aggregators) {
        GroupedQueryResult group = (GroupedQueryResult)res;
        Set<NVPair> groupBy = group.getGroupedAttributes();
        this.fillInAggregators(group, resultAggs, aggregators);
        GroupedQueryResult dest = uniqueGroups.get(groupBy);
        if (dest == null) {
            uniqueGroups.put(groupBy, group);
        } else {
            ResultTools.aggregate(dest.getAggregators(), group.getAggregators());
        }
    }

    private void fillInAggregators(GroupedQueryResult result, Collection<NVPair> resultAggs, Map<String, List<Aggregator>> aggs) {
        List<Aggregator> dest = result.getAggregators();
        Collection countAggs = aggs.get(COUNT_AGG_NAME);
        if (countAggs != null) {
            if (countAggs.isEmpty()) {
                throw new AssertionError((Object)"Count aggregator: expected non-empty singleton list");
            }
            Count count = (Count)countAggs.iterator().next();
            Count clone = new Count(count.getAttributeName(), count.getType());
            clone.accept(result);
            dest.add(clone);
        }
        for (NVPair attr : resultAggs) {
            List<Aggregator> attrAggs = aggs.get(attr.getName());
            if (attrAggs == null) continue;
            for (Aggregator agg : attrAggs) {
                AbstractAggregator srcAgg = (AbstractAggregator)agg;
                AbstractAggregator destAgg = AbstractAggregator.aggregator(srcAgg.getOperation(), srcAgg.getAttributeName(), srcAgg.getType());
                destAgg.accept(ValueType.ENUM == attr.getType() ? AbstractNVPair.enumStorageString((AbstractNVPair.EnumNVPair)attr) : attr.getObjectValue());
                dest.add(destAgg);
            }
        }
    }

    private void reorderAggregators(List<NVPair> requestedAggs, boolean isGroupBy, SearchResult<? extends IndexQueryResult> result) {
        HashMap<Set<String>, Integer> aggPositions = new HashMap<Set<String>, Integer>();
        int n = 0;
        int ctCt = 0;
        for (NVPair nVPair : requestedAggs) {
            Integer prev;
            HashSet<String> key = new HashSet<String>(2);
            String name = nVPair.getName();
            if (AggregatorOperations.COUNT.equals(nVPair.getObjectValue())) {
                name = COUNT_AGG_NAME + ctCt++;
            }
            key.add(name);
            key.add(nVPair.getObjectValue().toString());
            if ((prev = aggPositions.put(key, n++)) != null) {
                throw new AssertionError((Object)String.format("Previous index mapping found for %s: %d", key, prev));
            }
        }
        if (!isGroupBy) {
            this.alignAggregators(aggPositions, result.getAggregators(), n, ctCt);
        } else {
            for (GroupedQueryResult groupedQueryResult : result.getQueryResults()) {
                this.alignAggregators(aggPositions, groupedQueryResult.getAggregators(), n, ctCt);
            }
        }
    }

    private void alignAggregators(Map<Set<String>, Integer> aggIndices, List<Aggregator> target, int totalAggCount, int countOfCounts) {
        Aggregator[] dest = new Aggregator[totalAggCount];
        for (Aggregator a : target) {
            AbstractAggregator agg = (AbstractAggregator)a;
            HashSet<String> id = new HashSet<String>();
            if (AggregatorOperations.COUNT.equals((Object)agg.getOperation())) {
                for (int i = 0; i < countOfCounts; ++i) {
                    id.add(COUNT_AGG_NAME + i);
                    id.add(agg.getOperation().toString());
                    int idx = aggIndices.get(id);
                    id.clear();
                    dest[idx] = agg;
                }
                continue;
            }
            id.add(agg.getAttributeName());
            id.add(agg.getOperation().toString());
            int idx = aggIndices.get(id);
            id.clear();
            dest[idx] = agg;
        }
        target.clear();
        target.addAll(Arrays.asList(dest));
    }

    private Map<String, List<Aggregator>> createAggregators(List<NVPair> requestedAggregators) {
        if (requestedAggregators.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, List<Aggregator>> rv = new HashMap<String, List<Aggregator>>();
        NVPair count = null;
        for (NVPair aggregator : requestedAggregators) {
            String attrName = aggregator.getName();
            if (AggregatorOperations.COUNT.equals(aggregator.getObjectValue())) {
                count = aggregator;
                continue;
            }
            ArrayList<Aggregator> attrAggregators = (ArrayList<Aggregator>)rv.get(attrName);
            if (attrAggregators == null) {
                attrAggregators = new ArrayList<Aggregator>();
                rv.put(attrName, attrAggregators);
            }
            attrAggregators.add(this.createAggregator(aggregator));
        }
        if (count != null) {
            rv.put(COUNT_AGG_NAME, Collections.singletonList(this.createAggregator(count)));
        }
        return rv;
    }

    private Aggregator createAggregator(NVPair aggregator) {
        AbstractNVPair.EnumNVPair enumPair = (AbstractNVPair.EnumNVPair)aggregator;
        String attributeName = enumPair.getName();
        LuceneIndexManager.AttributeProperties attrProps = this.parent.getSchema().get(attributeName);
        ValueType type = attrProps != null ? (attrProps.isEnum() ? ValueType.ENUM : Enum.valueOf(ValueType.class, attrProps.getType())) : null;
        AggregatorOperations aggregatorType = AggregatorOperations.values()[enumPair.getOrdinal()];
        return AbstractAggregator.aggregator(aggregatorType, attributeName, type);
    }

    private ValueType getTypeForAttribute(String attrName) {
        LuceneIndexManager.AttributeProperties attrProps = this.parent.getSchema().get(attrName);
        return attrProps == null ? null : (attrProps.isEnum() ? ValueType.ENUM : Enum.valueOf(ValueType.class, attrProps.getType()));
    }

    private void cleanupResults(ResultsFilter filter) throws IndexException {
        for (Map.Entry entry : this.resultSources.entrySet()) {
            QueryID id = (QueryID)entry.getKey();
            if (filter.accept(id)) continue;
            SearchResultSource results = (SearchResultSource)entry.getValue();
            try {
                if (results == SearchResultSource.NULL_SOURCE) continue;
                this.resultSources.remove(id);
                results.close();
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
        }
    }

    private static class SimpleCollector
    extends Collector {
        private final int maxResults;
        private final boolean unbounded;
        private final int topLevelBase;
        private int base;
        private final IntList ids = new IntList();

        private SimpleCollector(QueryInputs params, int parentBase, int maxResults) {
            List<NVPair> sortBy = params.getSortAttributes();
            this.unbounded = sortBy.size() > 0 || maxResults < 0;
            this.maxResults = maxResults;
            this.topLevelBase = parentBase;
        }

        @Override
        public void setScorer(Scorer scorer) {
        }

        @Override
        public void collect(int doc) {
            if (this.unbounded || this.ids.size() < this.maxResults) {
                this.ids.add(this.base + doc);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
            this.base = this.topLevelBase + reader.docBase;
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        IntList getDocIds() {
            return this.ids;
        }
    }

    private static class CompositeCollector
    implements DocIdList {
        private final MultiReader docReader;
        private final QueryInputs inputs;
        private final int maxResults;
        private final IntList ids = new IntList();

        CompositeCollector(MultiReader reader, QueryInputs params, int maxResults) {
            this.docReader = reader;
            this.maxResults = maxResults;
            this.inputs = params;
        }

        @Override
        public int size() {
            return this.ids.size();
        }

        @Override
        public int get(int index) {
            return this.ids.get(index);
        }

        void combine(IntList src) {
            this.ids.addAll(src);
            IntList.access$602(src, null);
        }

        void truncateIfNeeded() {
            if (this.maxResults >= 0 && this.ids.size() > this.maxResults) {
                this.ids.truncate(this.maxResults);
            }
        }

        private void sort() {
            if (this.inputs.getSortAttributes().isEmpty() || !this.inputs.getGroupByAttributes().isEmpty()) {
                return;
            }
            final QueryResultComparator cmp = new QueryResultComparator(this.inputs.getSortAttributes());
            this.ids.truncate(this.ids.size());
            List<NVPair> sortBy = this.inputs.getSortAttributes();
            final HashSet<String> sortFields = new HashSet<String>(sortBy.size());
            for (NVPair nv : sortBy) {
                sortFields.add(nv.getName());
            }
            final HashMap sortFieldCache = new HashMap(this.ids.size());
            Comparator<Integer> docCmp = new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    SortFieldProvider sf2;
                    SortFieldProvider sf1 = (SortFieldProvider)sortFieldCache.get(o1);
                    if (sf1 == null) {
                        sf1 = new SortFieldSource(o1, sortFields);
                        sortFieldCache.put(o1, sf1);
                    }
                    if ((sf2 = (SortFieldProvider)sortFieldCache.get(o2)) == null) {
                        sf2 = new SortFieldSource(o2, sortFields);
                        sortFieldCache.put(o2, sf2);
                    }
                    return cmp.compare(sf1, sf2);
                }
            };
            if (this.maxResults > 0 && this.ids.size() > this.maxResults * 2) {
                int i;
                PriorityQueue<Integer> queue = new PriorityQueue<Integer>(this.maxResults, Collections.reverseOrder(docCmp));
                for (i = 0; i < this.maxResults; ++i) {
                    queue.add(this.ids.get(i));
                }
                for (i = this.maxResults; i < this.ids.size; ++i) {
                    Integer toPurge;
                    Integer docId = this.ids.get(i);
                    if (docCmp.compare(docId, queue.peek()) < 0) {
                        toPurge = (Integer)queue.remove();
                        queue.offer(docId);
                    } else {
                        toPurge = docId;
                    }
                    sortFieldCache.remove(toPurge);
                }
                for (i = this.maxResults - 1; i >= 0; --i) {
                    ((IntList)this.ids).data[i] = (Integer)queue.remove();
                }
            } else {
                Arrays.sort(this.ids.data, docCmp);
            }
        }

        private final class SortFieldSource
        implements SortFieldProvider {
            private final int id;
            private final Set<String> sortFields;
            private List<NVPair> sortCache;

            private SortFieldSource(int docId, Set<String> sortBy) {
                this.id = docId;
                this.sortFields = sortBy;
            }

            @Override
            public List<NVPair> getSortAttributes() {
                if (this.sortCache == null) {
                    try {
                        this.sortCache = SearchResultsManager.loadSortFields(CompositeCollector.this.docReader.document(this.id, this.sortFields), CompositeCollector.this.inputs);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.sortCache;
            }
        }
    }

    private static class IntList {
        private int size = 0;
        private Integer[] data;

        IntList() {
            this(16);
        }

        IntList(int cap) {
            this.data = new Integer[cap];
        }

        int size() {
            return this.size;
        }

        void add(int toAdd) {
            if (this.size == this.data.length) {
                Integer[] temp = new Integer[this.data.length * 2];
                System.arraycopy(this.data, 0, temp, 0, this.data.length);
                this.data = temp;
            }
            this.data[this.size++] = toAdd;
        }

        void addAll(IntList ids) {
            int room = this.data.length - this.size;
            if (ids.size() <= room) {
                System.arraycopy(ids.data, 0, this.data, this.size, ids.size());
            } else {
                Integer[] temp = new Integer[this.size + ids.size()];
                System.arraycopy(this.data, 0, temp, 0, this.size);
                System.arraycopy(ids.data, 0, temp, this.size, ids.size());
                this.data = temp;
            }
            this.size += ids.size();
        }

        Integer get(int index) {
            return this.data[index];
        }

        void truncate(int newSize) {
            if (this.size < newSize) {
                throw new IllegalArgumentException();
            }
            Integer[] dest = new Integer[newSize];
            System.arraycopy(this.data, 0, dest, 0, newSize);
            this.data = dest;
            this.size = newSize;
        }

        static /* synthetic */ Integer[] access$602(IntList x0, Integer[] x1) {
            x0.data = x1;
            return x1;
        }
    }

    private static class EmptyDocIdList
    implements DocIdList {
        private EmptyDocIdList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int get(int index) {
            throw new NoSuchElementException("index: " + index);
        }
    }

    private static interface DocIdList {
        public int size();

        public int get(int var1);
    }

    private static interface ResultsFilter {
        public boolean accept(QueryID var1);
    }
}

