/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.NVPair;
import com.terracottatech.search.NVPairEnum;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractNVPair
implements NVPair {
    private final String name;

    AbstractNVPair(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return (Object)((Object)this.getType()) + "(" + this.getName() + "," + this.valueAsString() + ")";
    }

    @Override
    public abstract NVPair cloneWithNewName(String var1);

    public final boolean equals(Object obj) {
        NVPair other;
        if (obj instanceof AbstractNVPair && (other = (NVPair)obj).getName().equals(this.getName())) {
            return this.basicEquals(other);
        }
        return false;
    }

    @Override
    public int compareTo(NVPair other) {
        boolean otherNull;
        boolean thisNull = this.getObjectValue() == null;
        boolean bl = otherNull = other.getObjectValue() == null;
        if (!thisNull && !otherNull) {
            return ((Comparable)this.getObjectValue()).compareTo(other.getObjectValue());
        }
        return otherNull ? (thisNull ? 0 : 1) : -1;
    }

    abstract boolean basicEquals(NVPair var1);

    public final int hashCode() {
        return this.getType().hashCode() ^ this.name.hashCode() ^ this.valueAsString().hashCode();
    }

    @Override
    public abstract String valueAsString();

    @Override
    public abstract ValueType getType();

    public static NVPair createNVPair(String name, Object value, ValueType type) {
        if (value == null) {
            return new NullNVPair(name);
        }
        if (ValueType.ENUM.equals((Object)type)) {
            return AbstractNVPair.enumPairFromString(name, (String)value);
        }
        return AbstractNVPair.createNVPair(name, value);
    }

    public static EnumNVPair enumPairFromString(String name, String enumString) {
        String className = enumString.substring(0, enumString.length() - 10);
        int ordinal = Integer.parseInt(enumString.substring(enumString.length() - 10));
        return new EnumNVPair(name, className, ordinal);
    }

    public static String enumStorageString(EnumNVPair enumPair) {
        return AbstractNVPair.enumStorageString(enumPair.getClassName(), enumPair.getOrdinal());
    }

    public static String enumStorageString(Enum e) {
        return AbstractNVPair.enumStorageString(e.getDeclaringClass().getName(), e.ordinal());
    }

    private static String enumStorageString(String className, int ordinal) {
        StringBuilder sb = new StringBuilder(className.length() + 10);
        sb.append(className);
        String ordinalString = String.valueOf(ordinal);
        for (int i = ordinalString.length(); i < 10; ++i) {
            sb.append('0');
        }
        sb.append(ordinalString);
        return sb.toString();
    }

    public static NVPair createNVPair(String attributeName, Object value) {
        if (value == null) {
            return new NullNVPair(attributeName);
        }
        if (value instanceof Byte) {
            return new ByteNVPair(attributeName, (Byte)value);
        }
        if (value instanceof Boolean) {
            return new BooleanNVPair(attributeName, (Boolean)value);
        }
        if (value instanceof Character) {
            return new CharNVPair(attributeName, ((Character)value).charValue());
        }
        if (value instanceof Double) {
            return new DoubleNVPair(attributeName, (Double)value);
        }
        if (value instanceof Float) {
            return new FloatNVPair(attributeName, ((Float)value).floatValue());
        }
        if (value instanceof Integer) {
            return new IntNVPair(attributeName, (Integer)value);
        }
        if (value instanceof Short) {
            return new ShortNVPair(attributeName, (Short)value);
        }
        if (value instanceof Long) {
            return new LongNVPair(attributeName, (Long)value);
        }
        if (value instanceof String) {
            return new StringNVPair(attributeName, (String)value);
        }
        if (value instanceof byte[]) {
            return new ByteArrayNVPair(attributeName, (byte[])value);
        }
        if (value instanceof Date) {
            return new SqlDateNVPair(attributeName, (Date)value);
        }
        if (value instanceof java.util.Date) {
            return new DateNVPair(attributeName, (java.util.Date)value);
        }
        if (value instanceof ValueID) {
            return new ValueIdNVPair(attributeName, (ValueID)value);
        }
        if (value instanceof Enum) {
            return new EnumNVPair(attributeName, (Enum)value);
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
    }

    public static class ValueIdNVPair
    extends AbstractNVPair {
        private final ValueID id;

        public ValueIdNVPair(String name, ValueID oid) {
            super(name);
            this.id = oid;
        }

        @Override
        public Object getObjectValue() {
            return this.id;
        }

        public ValueID getValue() {
            return this.id;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new ValueIdNVPair(newName, this.id);
        }

        @Override
        boolean basicEquals(NVPair other) {
            if (other instanceof ValueIdNVPair) {
                return this.id.equals(((ValueIdNVPair)other).id);
            }
            return false;
        }

        @Override
        public String valueAsString() {
            return this.id.toString();
        }

        @Override
        public ValueType getType() {
            return ValueType.VALUE_ID;
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new ValueIdNVPair(this.getName(), (ValueID)newValue);
        }
    }

    public static class NullNVPair
    extends AbstractNVPair {
        public NullNVPair(String name) {
            super(name);
        }

        @Override
        public Object getObjectValue() {
            return null;
        }

        @Override
        boolean basicEquals(NVPair other) {
            return other instanceof NullNVPair;
        }

        @Override
        public String valueAsString() {
            return "null";
        }

        @Override
        public ValueType getType() {
            return ValueType.NULL;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new NullNVPair(newName);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            if (newValue != null) {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        public int compareTo(NVPair other) {
            if (!this.getName().equals(other.getName())) {
                throw new IllegalArgumentException("Names don't match: " + other);
            }
            return this.basicEquals(other) ? 0 : -1;
        }
    }

    public static class EnumNVPair
    extends AbstractNVPair
    implements NVPairEnum {
        private final String className;
        private final int ordinal;

        public EnumNVPair(String name, Enum e) {
            this(name, e.getDeclaringClass().getName(), e.ordinal());
        }

        @Override
        public Object getObjectValue() {
            try {
                return Class.forName(this.className, false, Thread.currentThread().getContextClassLoader()).getEnumConstants()[this.ordinal];
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public EnumNVPair(String name, String className, int ordinal) {
            super(name);
            this.className = className;
            this.ordinal = ordinal;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof EnumNVPair) {
                EnumNVPair other = (EnumNVPair)obj;
                return this.ordinal == other.ordinal && this.className.equals(other.className);
            }
            return false;
        }

        @Override
        public String valueAsString() {
            return this.className + "(" + this.ordinal + ")";
        }

        @Override
        public ValueType getType() {
            return ValueType.ENUM;
        }

        @Override
        public int getOrdinal() {
            return this.ordinal;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new EnumNVPair(newName, this.className, this.ordinal);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new EnumNVPair(this.getName(), (Enum)newValue);
        }

        @Override
        public int compareTo(NVPair other) {
            if (other instanceof NullNVPair) {
                return 1;
            }
            if (!(other instanceof EnumNVPair && this.getName().equals(other.getName()) && this.className.equals(((EnumNVPair)other).className))) {
                throw new IllegalArgumentException("Incompatible value given to compareTo: " + other);
            }
            return this.ordinal - ((EnumNVPair)other).ordinal;
        }
    }

    public static class SqlDateNVPair
    extends AbstractNVPair {
        private final Date value;

        public SqlDateNVPair(String name, Date value) {
            super(name);
            this.value = value;
        }

        public Date getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public String valueAsString() {
            return this.value.toString();
        }

        @Override
        public ValueType getType() {
            return ValueType.SQL_DATE;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof SqlDateNVPair) {
                return this.value.equals(((SqlDateNVPair)obj).value);
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new SqlDateNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new SqlDateNVPair(this.getName(), (Date)newValue);
        }
    }

    public static class DateNVPair
    extends AbstractNVPair {
        private final java.util.Date value;

        public DateNVPair(String name, java.util.Date value) {
            super(name);
            this.value = value;
        }

        public java.util.Date getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public String valueAsString() {
            return this.value.toString();
        }

        @Override
        public ValueType getType() {
            return ValueType.DATE;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof DateNVPair) {
                return this.value.equals(((DateNVPair)obj).value);
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new DateNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new DateNVPair(this.getName(), (java.util.Date)newValue);
        }
    }

    public static class ByteArrayNVPair
    extends AbstractNVPair {
        private final byte[] value;

        public ByteArrayNVPair(String name, byte[] value) {
            super(name);
            this.value = value;
        }

        public byte[] getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public String valueAsString() {
            ArrayList<Byte> list = new ArrayList<Byte>(this.value.length);
            for (byte b : this.value) {
                list.add(b);
            }
            return ((Object)list).toString();
        }

        @Override
        public ValueType getType() {
            return ValueType.BYTE_ARRAY;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof ByteArrayNVPair) {
                return Arrays.equals(this.value, ((ByteArrayNVPair)obj).value);
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new ByteArrayNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new ByteArrayNVPair(this.getName(), (byte[])newValue);
        }
    }

    public static class StringNVPair
    extends AbstractNVPair {
        private final String value;

        public StringNVPair(String name, String value) {
            super(name);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public String valueAsString() {
            return this.value;
        }

        @Override
        public ValueType getType() {
            return ValueType.STRING;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof StringNVPair) {
                return this.value.equals(((StringNVPair)obj).value);
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new StringNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new StringNVPair(this.getName(), (String)newValue);
        }
    }

    public static class LongNVPair
    extends AbstractNVPair {
        private final long value;

        public LongNVPair(String name, long value) {
            super(name);
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public String valueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        public ValueType getType() {
            return ValueType.LONG;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof LongNVPair) {
                return this.value == ((LongNVPair)obj).value;
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new LongNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new LongNVPair(this.getName(), (Long)newValue);
        }
    }

    public static class ShortNVPair
    extends AbstractNVPair {
        private final short value;

        public ShortNVPair(String name, short value) {
            super(name);
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public String valueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        public ValueType getType() {
            return ValueType.SHORT;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof ShortNVPair) {
                return this.value == ((ShortNVPair)obj).value;
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new ShortNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new ShortNVPair(this.getName(), (Short)newValue);
        }
    }

    public static class IntNVPair
    extends AbstractNVPair {
        private final int value;

        public IntNVPair(String name, int value) {
            super(name);
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public String valueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        public ValueType getType() {
            return ValueType.INT;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof IntNVPair) {
                return this.value == ((IntNVPair)obj).value;
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new IntNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new IntNVPair(this.getName(), (Integer)newValue);
        }
    }

    public static class FloatNVPair
    extends AbstractNVPair {
        private final float value;

        public FloatNVPair(String name, float value) {
            super(name);
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public String valueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        public ValueType getType() {
            return ValueType.FLOAT;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof FloatNVPair) {
                return this.value == ((FloatNVPair)obj).value;
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new FloatNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new FloatNVPair(this.getName(), ((Float)newValue).floatValue());
        }
    }

    public static class DoubleNVPair
    extends AbstractNVPair {
        private final double value;

        public DoubleNVPair(String name, double value) {
            super(name);
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public String valueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        public ValueType getType() {
            return ValueType.DOUBLE;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof DoubleNVPair) {
                return this.value == ((DoubleNVPair)obj).value;
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new DoubleNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new DoubleNVPair(this.getName(), (Double)newValue);
        }
    }

    public static class CharNVPair
    extends AbstractNVPair {
        private final char value;

        public CharNVPair(String name, char value) {
            super(name);
            this.value = value;
        }

        public char getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return Character.valueOf(this.value);
        }

        @Override
        public String valueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        public ValueType getType() {
            return ValueType.CHAR;
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof CharNVPair) {
                return this.value == ((CharNVPair)obj).value;
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new CharNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new CharNVPair(this.getName(), ((Character)newValue).charValue());
        }
    }

    public static class BooleanNVPair
    extends AbstractNVPair {
        private final boolean value;

        public BooleanNVPair(String name, boolean value) {
            super(name);
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public ValueType getType() {
            return ValueType.BOOLEAN;
        }

        @Override
        public String valueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof BooleanNVPair) {
                return this.value == ((BooleanNVPair)obj).value;
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new BooleanNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new BooleanNVPair(this.getName(), (Boolean)newValue);
        }
    }

    public static class ByteNVPair
    extends AbstractNVPair {
        private final byte value;

        public ByteNVPair(String name, byte value) {
            super(name);
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        @Override
        public Object getObjectValue() {
            return this.value;
        }

        @Override
        public ValueType getType() {
            return ValueType.BYTE;
        }

        @Override
        public String valueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        boolean basicEquals(NVPair obj) {
            if (obj instanceof ByteNVPair) {
                return this.value == ((ByteNVPair)obj).value;
            }
            return false;
        }

        @Override
        public NVPair cloneWithNewName(String newName) {
            return new ByteNVPair(newName, this.value);
        }

        @Override
        public NVPair cloneWithNewValue(Object newValue) {
            return new ByteNVPair(this.getName(), (Byte)newValue);
        }
    }
}

