/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.pinning.PinnableCache;
import com.terracottatech.offheapstore.pinning.PinnableSegment;
import com.terracottatech.offheapstore.util.Factory;
import java.util.Arrays;
import java.util.Comparator;

public abstract class AbstractConcurrentOffHeapCache<K, V>
extends AbstractConcurrentOffHeapMap<K, V>
implements PinnableCache<K, V> {
    private static final Comparator<Segment<?, ?>> SIZE_COMPARATOR = new Comparator<Segment<?, ?>>(){

        @Override
        public int compare(Segment<?, ?> o1, Segment<?, ?> o2) {
            return (int)(o2.getSize() - o1.getSize());
        }
    };

    public AbstractConcurrentOffHeapCache(Factory<? extends PinnableSegment<K, V>> segmentFactory) {
        super(segmentFactory);
    }

    public AbstractConcurrentOffHeapCache(Factory<? extends Segment<K, V>> segmentFactory, int concurrency) {
        super(segmentFactory, concurrency);
    }

    @Override
    public V put(K key, V value) {
        try {
            return super.put(key, value);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return super.put(key, value);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    V ex = super.put(key, value);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    @Override
    public V fill(K key, V value) {
        try {
            return super.fill(key, value);
        }
        catch (OversizeMappingException e) {
            return null;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        try {
            return super.putIfAbsent(key, value);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return super.putIfAbsent(key, value);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    V ex = super.putIfAbsent(key, value);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        try {
            return super.replace(key, oldValue, newValue);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return super.replace(key, oldValue, newValue);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    boolean ex = super.replace(key, oldValue, newValue);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    @Override
    public V replace(K key, V value) {
        try {
            return super.replace(key, value);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return super.replace(key, value);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    V ex = super.replace(key, value);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    public final boolean handleOversizeMappingException(int hash) {
        boolean evicted = false;
        Segment target = this.segmentFor(hash);
        for (Segment s : this.segments) {
            if (s == target) continue;
            evicted |= s.shrink();
        }
        return evicted;
    }

    public V getAndPin(K key) {
        return this.segmentFor(key).getAndSetMetadata(key, 0x40000000, 0x40000000);
    }

    @Override
    public V putPinned(K key, V value) {
        try {
            return this.segmentFor(key).putPinned(key, value);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return this.segmentFor(key).putPinned(key, value);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    V ex = this.segmentFor(key).putPinned(key, value);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    public boolean pin(K key) {
        return this.setPinned(key, true);
    }

    public boolean unpin(K key) {
        return this.setPinned(key, false);
    }

    private boolean setPinned(K key, boolean pin) {
        return this.updateMetadata(key, 0x40000000, pin ? 0x40000000 : 0);
    }

    @Override
    public boolean isPinned(Object key) {
        return this.segmentFor(key).isPinned(key);
    }

    @Override
    public void setPinning(K key, boolean pinned) {
        try {
            this.segmentFor(key).setPinning(key, pinned);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    this.segmentFor(key).setPinning(key, pinned);
                    return;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    this.segmentFor(key).setPinning(key, pinned);
                    return;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    @Override
    protected PinnableSegment<K, V> segmentFor(Object key) {
        return (PinnableSegment)super.segmentFor(key);
    }

    public boolean shrink() {
        Segment[] sorted = (Segment[])this.segments.clone();
        Arrays.sort(sorted, SIZE_COMPARATOR);
        for (Segment s : sorted) {
            if (!s.shrink()) continue;
            return true;
        }
        return false;
    }

    public boolean shrinkOthers(int excludedHash) {
        boolean evicted = false;
        Segment target = this.segmentFor(excludedHash);
        for (Segment s : this.segments) {
            if (s == target) continue;
            evicted |= s.shrink();
        }
        return evicted;
    }
}

