/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.WrappingChunk;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRegionPacker;
import com.terracottatech.frs.log.Signature;
import java.nio.ByteBuffer;
import java.util.Collections;

public class CopyingPacker
extends LogRegionPacker {
    private final BufferSource pool;
    private static final int FUTURE_SPACER = 64;

    public CopyingPacker(Signature sig, BufferSource copyInto) {
        super(sig);
        this.pool = copyInto;
    }

    private int sizeRegion(Iterable<LogRecord> records) {
        int size = 0;
        for (LogRecord r : records) {
            ByteBuffer[] s;
            for (ByteBuffer b : s = r.getPayload()) {
                size += b.remaining();
            }
            size += 18;
        }
        size += 20;
        return size += 128;
    }

    @Override
    protected Chunk writeRecords(Iterable<LogRecord> records) {
        int size = this.sizeRegion(records);
        if (size < 1024) {
            return super.writeRecords(records);
        }
        ByteBuffer raw = this.pool.getBuffer(size);
        if (raw == null) {
            return super.writeRecords(records);
        }
        raw.position(64);
        ByteBuffer header = raw.slice();
        header.position(20);
        for (LogRecord record : records) {
            ByteBuffer copy = header.slice();
            copy.position(18);
            ByteBuffer[] payload = record.getPayload();
            long len = 0L;
            for (ByteBuffer bb : payload) {
                len += (long)bb.remaining();
                copy.put(bb);
            }
            header.position(header.position() + copy.position());
            copy.flip();
            this.formRecordHeader(len, record.getLsn(), copy);
        }
        header.flip();
        this.formRegionHeader(this.doChecksum() ? CopyingPacker.checksum(Collections.singletonList((ByteBuffer)header.duplicate().position(20))) : 0L, header.duplicate());
        raw.limit(64 + header.remaining());
        return new WrappingChunk(raw);
    }
}

