/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.log.CommitList;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRecordImpl;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicCommitList
implements CommitList {
    private static final LogRecord DUMMY_RECORD = new LogRecordImpl(null, null);
    private final Object guard = new Object();
    private final AtomicReferenceArray<LogRecord> regions;
    private final AtomicLong endLsn;
    private final CountDownLatch goLatch;
    private final long baseLsn;
    private final AtomicLong syncRequest = new AtomicLong();
    private boolean written = false;
    private Exception error;
    private volatile CommitList next;
    private final int wait;
    private volatile boolean atHead = false;
    private volatile boolean requestFileClose = false;

    public AtomicCommitList(long startLsn, int maxSize, int waitTime) {
        this.baseLsn = startLsn;
        this.endLsn = new AtomicLong();
        this.regions = new AtomicReferenceArray(maxSize);
        this.goLatch = new CountDownLatch(maxSize);
        this.wait = waitTime;
    }

    @Override
    public boolean append(LogRecord record, boolean sync, boolean closeFile) {
        if (record == null) {
            return true;
        }
        assert (record.getLsn() >= this.baseLsn);
        if (record.getLsn() >= (long)this.regions.length() + this.baseLsn) {
            return false;
        }
        long end = this.endLsn.get();
        if (end > 0L && end < record.getLsn()) {
            return false;
        }
        if (sync) {
            this.setSyncRequest(record.getLsn());
        }
        if (this.regions.compareAndSet((int)(record.getLsn() - this.baseLsn), null, record)) {
            this.goLatch.countDown();
            if (closeFile) {
                this.requestFileClose = true;
            }
            if (this.atHead && sync) {
                this.checkForClosed();
            }
        } else {
            return false;
        }
        return true;
    }

    private void setSyncRequest(long newRequest) {
        long csync = this.syncRequest.get();
        while (csync < newRequest) {
            if (this.syncRequest.compareAndSet(csync, newRequest)) continue;
            csync = this.syncRequest.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitList next() {
        if (this.next == null) {
            long nextLsn = this.endLsn.get() + 1L;
            if (nextLsn == 1L) {
                nextLsn = this.endLsn.compareAndSet(0L, this.baseLsn + (long)this.regions.length() - 1L) ? this.baseLsn + (long)this.regions.length() : this.endLsn.get() + 1L;
            }
            Object object = this.guard;
            synchronized (object) {
                if (this.next == null) {
                    this.next = this.create(nextLsn);
                }
            }
        }
        return this.next;
    }

    @Override
    public CommitList create(long nextLsn) {
        return new AtomicCommitList(nextLsn, this.regions.length(), this.wait);
    }

    @Override
    public long getBaseLsn() {
        return this.baseLsn;
    }

    @Override
    public long getEndLsn() {
        return this.endLsn.get();
    }

    @Override
    public boolean isEmpty() {
        return this.baseLsn > this.endLsn.get();
    }

    @Override
    public boolean close(long end) {
        if (end >= this.baseLsn + (long)this.regions.length()) {
            return false;
        }
        boolean closer = this.endLsn.compareAndSet(0L, end);
        if (!closer) {
            return end <= this.endLsn.get();
        }
        this.transferOutExtras();
        return true;
    }

    private void transferOutExtras() {
        int offset;
        CommitList cnext = this.next();
        for (int x = offset = (int)(this.endLsn.get() - this.baseLsn + 1L); x < this.regions.length(); ++x) {
            LogRecord record = this.regions.getAndSet(x, DUMMY_RECORD);
            if (record == null) {
                this.goLatch.countDown();
                continue;
            }
            CommitList nnext = cnext;
            while (!nnext.append(record, this.syncRequest.get() >= record.getLsn(), this.requestFileClose)) {
                nnext = nnext.next();
            }
        }
    }

    @Override
    public boolean isSegmentCloseRequested() {
        return this.requestFileClose;
    }

    @Override
    public boolean isSyncRequested() {
        return this.syncRequest.get() > 0L;
    }

    private void waitForWrite() throws InterruptedException, ExecutionException {
        this.waitForWrite(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWrite(long millis) throws InterruptedException, ExecutionException {
        long span = System.currentTimeMillis();
        Object object = this.guard;
        synchronized (object) {
            while (!this.written) {
                if (this.error != null) {
                    throw new ExecutionException(this.error);
                }
                if (millis != 0L && System.currentTimeMillis() - span > millis) {
                    return;
                }
                this.guard.wait(millis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWritten() {
        Object object = this.guard;
        synchronized (object) {
            return this.written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void written() {
        Object object = this.guard;
        synchronized (object) {
            this.written = true;
            this.guard.notifyAll();
        }
    }

    private boolean checkValues() {
        int x = 0;
        while ((long)x < this.endLsn.get() - this.baseLsn + 1L) {
            if (this.regions.get(x) == null || this.regions.get(x).getLsn() != this.baseLsn + (long)x) {
                return false;
            }
            ++x;
        }
        if (this.endLsn.get() - this.baseLsn + 1L == 0L) {
            return true;
        }
        return true;
    }

    @Override
    public void waitForContiguous() throws InterruptedException {
        this.atHead = true;
        if (this.goLatch.getCount() != (long)this.regions.length()) {
            this.checkForClosed();
        }
        while (!this.goLatch.await(this.wait, TimeUnit.MILLISECONDS)) {
            if (this.goLatch.getCount() == (long)this.regions.length()) continue;
            this.checkForClosed();
        }
        if (this.endLsn.compareAndSet(0L, this.baseLsn + (long)this.regions.length() - 1L)) assert (this.goLatch.getCount() == 0L);
        assert (this.baseLsn == 0L || this.checkValues());
    }

    @Override
    public boolean cancel(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void checkForClosed() {
        if (this.endLsn.get() == 0L) {
            int size = this.regions.length() - (int)this.goLatch.getCount();
            LogRecord record = null;
            while (record == null && size-- > 0) {
                record = this.regions.get(size);
            }
            if (size >= 0) {
                this.close(record.getLsn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionThrown(Exception exp) {
        Object object = this.guard;
        synchronized (object) {
            this.error = exp;
            this.guard.notifyAll();
        }
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        this.waitForWrite();
        return null;
    }

    @Override
    public Void get(long time, TimeUnit tu) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitForWrite(tu.convert(time, TimeUnit.MILLISECONDS));
        return null;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.goLatch.getCount() == (long)this.regions.length() || this.isWritten();
    }

    @Override
    public Iterator<LogRecord> iterator() {
        assert (this.endLsn.get() > 0L);
        final int total = (int)(this.endLsn.get() - this.baseLsn + 1L);
        return new Iterator<LogRecord>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < total;
            }

            @Override
            public LogRecord next() {
                return (LogRecord)AtomicCommitList.this.regions.get(this.current++);
            }

            @Override
            public void remove() {
            }
        };
    }
}

