/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.nio.ReadbackStrategy;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

abstract class AbstractReadbackStrategy
implements ReadbackStrategy {
    private boolean consistent = false;

    @Override
    public boolean isConsistent() {
        return this.consistent;
    }

    protected ByteBuffer[] readChunk(Chunk buffer) throws IOException {
        if (!buffer.hasRemaining()) {
            return null;
        }
        if (buffer.remaining() < 12L) {
            return null;
        }
        int start = buffer.getInt();
        if (!SegmentHeaders.CHUNK_START.validate(start)) {
            if (SegmentHeaders.CLOSE_FILE.validate(start)) {
                this.consistent = true;
            }
            return null;
        }
        long length = buffer.getLong();
        if (buffer.remaining() < length + 8L + 8L + 4L) {
            return null;
        }
        ByteBuffer[] targets = buffer.getBuffers(length);
        if (length != buffer.getLong()) {
            return null;
        }
        buffer.getLong();
        if (!SegmentHeaders.FILE_CHUNK.validate(buffer.getInt())) {
            return null;
        }
        return targets;
    }

    protected ArrayList<Long> readJumpList(Chunk buffer) throws IOException {
        long LAST_INT_WORD_IN_CHUNK = buffer.length() - 4L;
        long LAST_SHORT_WORD_BEFORE_JUMP_MARK = LAST_INT_WORD_IN_CHUNK - 2L;
        int jump = buffer.getInt(LAST_INT_WORD_IN_CHUNK);
        if (SegmentHeaders.JUMP_LIST.validate(jump)) {
            int numberOfChunks = buffer.getShort(LAST_SHORT_WORD_BEFORE_JUMP_MARK);
            if (numberOfChunks < 0) {
                return null;
            }
            int reach = numberOfChunks * 8;
            long EXPECTED_CLOSE_POSITION = LAST_SHORT_WORD_BEFORE_JUMP_MARK - (long)reach - 4L;
            if (EXPECTED_CLOSE_POSITION < 0L) {
                return null;
            }
            int cfm = buffer.getInt(EXPECTED_CLOSE_POSITION);
            if (SegmentHeaders.CLOSE_FILE.validate(cfm)) {
                ArrayList<Long> jumps = new ArrayList<Long>(numberOfChunks);
                for (int x = 0; x < numberOfChunks; ++x) {
                    jumps.add(buffer.getLong(EXPECTED_CLOSE_POSITION + 4L + (long)(x * 8)));
                }
                return jumps;
            }
        }
        return null;
    }
}

