/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.IOManager;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatingBufferSource
implements BufferSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOManager.class);
    private ReferenceQueue<ByteBuffer> queue = new ReferenceQueue();
    BufferSource parent;
    private final HashSet<BaseHolder> used = new HashSet();
    private int created = 0;
    private int released = 0;
    private long totalCapacity = 0L;
    private int spinsToFail = 0;
    private long millisToWait = 250L;

    public RotatingBufferSource(BufferSource parent) {
        this.parent = parent;
    }

    public void spinsToFail(int spins) {
        this.spinsToFail = spins;
    }

    public void millisToWait(long millis) {
        this.millisToWait = millis;
    }

    @Override
    public ByteBuffer getBuffer(int size) {
        ByteBuffer factor = null;
        int spins = 1;
        while (factor == null) {
            this.clearQueue(spins > 1);
            factor = this.checkFree(size + 8);
            if (factor != null) continue;
            if (this.spinsToFail >= 0 && spins++ > this.spinsToFail) {
                return null;
            }
            System.gc();
        }
        factor = this.addUsed(factor, size);
        return factor;
    }

    public void clear() {
        this.clearQueue(false);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    private void clearQueue(boolean wait) {
        try {
            BaseHolder holder = null;
            holder = wait ? (BaseHolder)this.queue.remove(this.millisToWait) : (BaseHolder)this.queue.poll();
            while (holder != null) {
                if (this.used.remove(holder)) {
                    ByteBuffer check = holder.getBase();
                    this.totalCapacity -= (long)check.capacity();
                    this.parent.returnBuffer(check);
                }
                holder = (BaseHolder)this.queue.poll();
            }
        }
        catch (InterruptedException re) {
            throw new RuntimeException(re);
        }
    }

    private ByteBuffer addUsed(ByteBuffer buffer, int size) {
        if (!buffer.isDirect()) {
            return buffer;
        }
        if (buffer.capacity() < size + 8) {
            throw new AssertionError();
        }
        buffer.clear().position(buffer.capacity() - size);
        ByteBuffer pass = buffer.slice();
        this.used.add(new BaseHolder(buffer, pass));
        buffer.putInt(0, buffer.getInt(0) + 1);
        this.totalCapacity += (long)buffer.capacity();
        return pass;
    }

    private ByteBuffer checkFree(int request) {
        return this.parent.getBuffer(request);
    }

    @Override
    public void reclaim() {
        this.clearQueue(false);
    }

    @Override
    public void returnBuffer(ByteBuffer buffer) {
    }

    public int getCount() {
        return this.created;
    }

    public int getReleased() {
        return this.released;
    }

    public long getCapacity() {
        return this.totalCapacity;
    }

    class BaseHolder
    extends PhantomReference<ByteBuffer> {
        final ByteBuffer baseBuffer;

        public BaseHolder(ByteBuffer base, ByteBuffer t) {
            super(t, RotatingBufferSource.this.queue);
            this.baseBuffer = base;
        }

        public ByteBuffer getBase() {
            return this.baseBuffer;
        }
    }
}

