/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

public class HtmlDivLine {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;
    private final float width;
    private final float height;
    private final float lineWidth;
    private final boolean horizontal;
    private final boolean vertical;

    public HtmlDivLine(float x1, float y1, float x2, float y2, float lineWidth) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.lineWidth = lineWidth;
        this.width = Math.abs(x2 - x1);
        this.height = Math.abs(y2 - y1);
        this.horizontal = this.height < 0.5f;
        this.vertical = this.width < 0.5f;
    }

    public float getHeight() {
        return this.vertical ? this.height : 0.0f;
    }

    public float getWidth() {
        if (this.vertical) {
            return 0.0f;
        }
        if (this.horizontal) {
            return this.width;
        }
        return this.distanceFormula(this.x1, this.y1, this.x2, this.y2);
    }

    public float getLeft() {
        if (this.horizontal || this.vertical) {
            return Math.min(this.x1, this.x2);
        }
        return Math.abs((this.x2 + this.x1) / 2.0f) - this.getWidth() / 2.0f;
    }

    public float getTop() {
        if (this.horizontal || this.vertical) {
            return Math.min(this.y1, this.y2);
        }
        return Math.abs((this.y2 + this.y1) / 2.0f) - (this.getLineStrokeWidth() + this.getHeight()) / 2.0f;
    }

    public double getAngleDegrees() {
        if (this.horizontal || this.vertical) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan((this.y2 - this.y1) / (this.x2 - this.x1)));
    }

    public float getLineStrokeWidth() {
        float lw = this.lineWidth;
        if (lw < 0.5f) {
            lw = 0.5f;
        }
        return lw;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public String getBorderSide() {
        return this.vertical ? "border-right" : "border-bottom";
    }

    private float distanceFormula(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }
}

