/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.fop0205;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.DirectPropertyListBuilder;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.messaging.MessageHandler;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.fop0205.BarcodeArea;
import org.krysalis.barcode4j.fop0205.BarcodeObj;
import org.krysalis.barcode4j.fop0205.VariableUtil;
import org.krysalis.barcode4j.tools.ConfigurationUtil;
import org.krysalis.barcode4j.tools.UnitConv;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class BarcodeElement
extends BarcodeObj {
    private static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    FontState fs;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public BarcodeElement(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, "barcode", systemId, line, column);
        this.init();
    }

    protected void init() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new CascadingRuntimeException("Error creating DOM", (Throwable)pce);
        }
        this.doc.appendChild(this.doc.createElementNS("http://barcode4j.krysalis.org/ns", "barcode"));
        this.element = this.doc.getDocumentElement();
        this.buildTopLevel(this.doc, this.element);
    }

    public void buildTopLevel(Document doc, Element svgRoot) {
        if (this.properties instanceof DirectPropertyListBuilder.AttrPropertyList) {
            Attributes attr = ((DirectPropertyListBuilder.AttrPropertyList)this.properties).getAttributes();
            for (int count = 0; count < attr.getLength(); ++count) {
                String rf = attr.getValue(count);
                String qname = attr.getQName(count);
                if (qname.indexOf(":") == -1) {
                    this.element.setAttribute(qname, rf);
                    continue;
                }
                String pref = qname.substring(0, qname.indexOf(":"));
                ns.put("xlink", "http://www.w3.org/1999/xlink");
                if (pref.equals("xmlns")) {
                    ns.put(qname.substring(qname.indexOf(":") + 1), rf);
                    this.element.setAttributeNS(XMLNS_NAMESPACE_URI, qname, rf);
                    continue;
                }
                this.element.setAttributeNS((String)ns.get(pref), qname, rf);
            }
        }
    }

    protected BarcodeArea createArea(FontState fontState, float width, float height) {
        return new BarcodeArea(fontState, width, height);
    }

    public int layout(Area area) throws FOPException {
        if (!(area instanceof ForeignObjectArea)) {
            throw new FOPException("Barcode not in fo:instream-foreign-object");
        }
        if (this.marker == -1000) {
            this.fs = area.getFontState();
            this.marker = 0;
        }
        ForeignObjectArea foa = (ForeignObjectArea)area;
        Element e = this.doc.getDocumentElement();
        e.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns", "http://barcode4j.krysalis.org/ns");
        Configuration cfg = ConfigurationUtil.buildConfiguration((Node)this.doc);
        try {
            String msg;
            try {
                msg = cfg.getAttribute("message");
            }
            catch (ConfigurationException ce) {
                try {
                    msg = cfg.getAttribute("msg");
                }
                catch (ConfigurationException ce1) {
                    throw ce;
                }
            }
            int orientation = cfg.getAttributeAsInteger("orientation", 0);
            String renderMode = cfg.getAttribute("render-mode", "native");
            BarcodeGenerator bargen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg);
            String expandedMsg = VariableUtil.getExpandedMessage(foa.getPage(), msg);
            BarcodeDimension bardim = bargen.calcDimensions(expandedMsg);
            float w = (float)UnitConv.mm2pt((double)bardim.getWidthPlusQuiet(orientation)) * 1000.0f;
            float h = (float)UnitConv.mm2pt((double)bardim.getHeightPlusQuiet(orientation)) * 1000.0f;
            BarcodeArea barcodeArea = this.createArea(this.fs, w, h);
            barcodeArea.setParent((Area)foa);
            barcodeArea.setPage(foa.getPage());
            barcodeArea.setBarcode(bargen, expandedMsg, renderMode, orientation);
            barcodeArea.start();
            barcodeArea.end();
            foa.setObject((Area)barcodeArea);
            foa.setIntrinsicWidth(barcodeArea.getWidth());
            foa.setIntrinsicHeight(barcodeArea.getHeight());
            return 1;
        }
        catch (ConfigurationException ce) {
            MessageHandler.errorln((String)("Error in barcode XML: " + ce.getMessage()));
            throw new FOPException("Error in barcode XML", (Throwable)ce);
        }
        catch (BarcodeException be) {
            MessageHandler.errorln((String)("Error generating barcode: " + be.getMessage()));
            throw new FOPException("Error generating barcode", (Throwable)be);
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new BarcodeElement(parent, propertyList, systemId, line, column);
        }
    }
}

