/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.random;

import java.security.SecureRandom;
import net.schmizz.sshj.transport.random.Random;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;

public class BouncyCastleRandom
implements Random {
    private final RandomGenerator random = new VMPCRandomGenerator();

    public BouncyCastleRandom() {
        byte[] seed = new SecureRandom().generateSeed(8);
        this.random.addSeedMaterial(seed);
    }

    @Override
    public void fill(byte[] bytes, int start, int len) {
        this.random.nextBytes(bytes, start, len);
    }

    public static class Factory
    implements net.schmizz.sshj.common.Factory<Random> {
        @Override
        public Random create() {
            return new BouncyCastleRandom();
        }
    }
}

