/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import net.scarlettsystems.android.widget.Helpers;
import net.scarlettsystems.android.widget.R;

class ScarlettRecyclerAdapter
extends RecyclerView.Adapter {
    private boolean mAnimationEnabled = true;
    private ArrayList<Object> mDataset = new ArrayList();
    private ArrayList<Integer> mTypeset = new ArrayList();
    private OnItemClickListener mItemClickListener = null;
    private SparseArray<ItemViewListener> mItemViewListeners = new SparseArray();
    private ItemViewListener mErrorListener;
    private RecyclerView mRecyclerView;
    private LoaderHolder mLoaderHolder;
    private Interpolator mLoaderShowInterpolator = new LinearInterpolator();
    private Interpolator mLoaderHideInterpolator = new LinearInterpolator();
    private int mDuration;
    private int mLoaderHeight = 100;
    private int[] mLoaderPadding = new int[]{0, 0, 0, 0};

    ScarlettRecyclerAdapter() {
        this.mDataset.add(new LoaderObject());
        this.mErrorListener = new ItemViewListener(){

            @Override
            public View OnCreateItemView(ViewGroup parent) {
                Log.e((String)"EasyRecyclerView", (String)"View request for unrecognised item. Set OnCreateItemView or layout resource for this item type.");
                return new View(parent.getContext());
            }

            @Override
            public void OnBindItemView(View v, Object item) {
                Log.e((String)"EasyRecyclerView", (String)"Bind request for unrecognised item. Set OnBindItemView for this item type.");
            }
        };
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
        View view = LayoutInflater.from((Context)recyclerView.getContext()).inflate(R.layout.net_scarlettsystems_android_widget_cardloader, null, false);
        this.mLoaderHolder = new LoaderHolder(view);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == -1) {
            parent.addView(this.mLoaderHolder.mView);
            return this.mLoaderHolder;
        }
        if (viewType >= 0) {
            View view = ((ItemViewListener)this.mItemViewListeners.get(viewType, (Object)this.mErrorListener)).OnCreateItemView(parent);
            if (view == null) {
                throw new IllegalArgumentException("OnCreateItemView must return a view.");
            }
            return new ItemHolder(view);
        }
        throw new IllegalArgumentException();
    }

    public void onBindViewHolder(RecyclerView.ViewHolder vh, int position) {
        if (vh instanceof ItemHolder) {
            ItemHolder h = (ItemHolder)vh;
            h.setItem(this.mDataset.get(position));
            ((ItemViewListener)this.mItemViewListeners.get(this.mTypeset.get(position).intValue(), (Object)this.mErrorListener)).OnBindItemView(h.getView(), h.getItem());
        }
    }

    void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    void addOnItemViewListener(ItemViewListener l, int typeCode) {
        this.mItemViewListeners.append(typeCode, (Object)l);
    }

    void removeOnItemViewListener(int typeCode) {
        this.mItemViewListeners.remove(typeCode);
    }

    void setAnimationDuration(int value) {
        this.mDuration = value;
    }

    void setLoaderHeight(int value) {
        this.mLoaderHeight = value;
    }

    Object getItem(int index) {
        if (index >= this.getItemCountProtected()) {
            throw new IndexOutOfBoundsException();
        }
        return this.mDataset.get(index);
    }

    ArrayList<Object> getItems(int startIndex, int count) {
        return new ArrayList<Object>(this.mDataset.subList(startIndex, startIndex + count));
    }

    ArrayList<Object> getItems() {
        return new ArrayList<Object>(this.mDataset.subList(0, this.getItemCountProtected()));
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mDataset.size();
    }

    public int getItemCountProtected() {
        return this.mDataset.size() - 1;
    }

    public int getItemViewType(int position) {
        if (this.mDataset.get(position) instanceof LoaderObject) {
            return -1;
        }
        int index = this.mTypeset.get(position);
        if (index == -1) {
            throw new IllegalStateException();
        }
        return index;
    }

    void addItem(Object item, int typeCode) {
        this.mDataset.add(this.getItemCountProtected(), item);
        this.mTypeset.add(typeCode);
        this.notifyItemInserted(this.getItemCountProtected());
    }

    void addItems(ArrayList<?> items, int typeCode) {
        this.mDataset.addAll(this.getItemCountProtected(), items);
        for (int c = 0; c < items.size(); ++c) {
            this.mTypeset.add(typeCode);
        }
        this.notifyItemRangeInserted(this.getItemCountProtected(), items.size());
    }

    void addItemAt(Object item, int index, int typeCode) {
        this.mDataset.add(index, item);
        this.mTypeset.add(index, typeCode);
        this.notifyItemInserted(index);
    }

    void removeItem(int index) {
        this.mDataset.remove(index);
        this.mTypeset.remove(index);
        this.notifyItemRemoved(index);
    }

    void removeAll() {
        int originalItemCount = this.getItemCountProtected();
        Object loader = this.mDataset.get(originalItemCount);
        this.mDataset.clear();
        this.mTypeset.clear();
        this.mDataset.add(loader);
        this.notifyItemRangeRemoved(0, originalItemCount);
    }

    int indexOf(Object item) {
        return this.mDataset.indexOf(item);
    }

    void showLoader() {
        if (this.mLoaderHolder == null) {
            return;
        }
        this.mLoaderHolder.showLoader();
    }

    void hideLoader() {
        if (this.mLoaderHolder == null) {
            return;
        }
        this.mLoaderHolder.hideLoader();
    }

    boolean isLoaderShown() {
        if (this.mLoaderHolder == null) {
            return false;
        }
        return this.mLoaderHolder.isShown();
    }

    void setAnimationEnabled(boolean enabled) {
        this.mAnimationEnabled = enabled;
    }

    void setLoaderPadding(int padding) {
        for (int c = 0; c < this.mLoaderPadding.length; ++c) {
            this.mLoaderPadding[c] = padding;
        }
    }

    void setLoaderPaddingTop(int padding) {
        this.mLoaderPadding[1] = padding;
    }

    void setLoaderPaddingBottom(int padding) {
        this.mLoaderPadding[3] = padding;
    }

    void setLoaderColour(int colour) {
        this.mLoaderHolder.setLoaderColour(colour);
    }

    void setLoaderShowInterpolator(Interpolator interpolator) {
        this.mLoaderShowInterpolator = interpolator;
    }

    void setLoaderHideInterpolator(Interpolator interpolator) {
        this.mLoaderHideInterpolator = interpolator;
    }

    void setBottomPadding(int padding) {
        this.mLoaderHolder.setBottomPadding(padding);
    }

    public static interface ItemViewListener {
        public View OnCreateItemView(ViewGroup var1);

        public void OnBindItemView(View var1, Object var2);
    }

    public static interface OnItemClickListener {
        public void OnItemClick(View var1, Object var2);
    }

    private class LoaderObject {
        private LoaderObject() {
        }
    }

    private class LoaderHolder
    extends RecyclerView.ViewHolder {
        private View mView;
        private RelativeLayout loaderContainer;
        private RelativeLayout paddingView;
        private ProgressBar loader;
        private boolean isShown;

        LoaderHolder(View itemView) {
            super(itemView);
            this.isShown = false;
            this.mView = itemView;
            this.paddingView = (RelativeLayout)itemView.findViewById(R.id.net_scarlettsystems_android_widget_cardloader_padding);
            this.loaderContainer = (RelativeLayout)itemView.findViewById(R.id.net_scarlettsystems_android_widget_cardloader_loader_container);
            this.loader = (ProgressBar)itemView.findViewById(R.id.net_scarlettsystems_android_widget_cardloader_loader);
            Helpers.setViewHeight((View)this.loader, 0);
            if (itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
                StaggeredGridLayoutManager.LayoutParams layoutParams = new StaggeredGridLayoutManager.LayoutParams(-1, -2);
                layoutParams.setFullSpan(true);
                itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }

        void showLoader() {
            this.loaderContainer.setVisibility(0);
            if (ScarlettRecyclerAdapter.this.mAnimationEnabled) {
                ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, ScarlettRecyclerAdapter.this.mLoaderHeight});
                animator.setDuration((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.setInterpolator((TimeInterpolator)ScarlettRecyclerAdapter.this.mLoaderShowInterpolator);
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        int[] pad = new int[]{0, 0, 0, 0};
                        for (int c = 0; c < ScarlettRecyclerAdapter.this.mLoaderPadding.length; ++c) {
                            pad[c] = Math.round((float)ScarlettRecyclerAdapter.this.mLoaderPadding[c] * animator.getAnimatedFraction());
                        }
                        Helpers.setViewHeight((View)LoaderHolder.this.loader, (Integer)animator.getAnimatedValue());
                        LoaderHolder.this.loaderContainer.setPadding(pad[0], pad[1], pad[2], pad[3]);
                        ScarlettRecyclerAdapter.this.mRecyclerView.scrollToPosition(ScarlettRecyclerAdapter.this.mRecyclerView.getLayoutManager().getItemCount() - 1);
                    }
                });
                animator.start();
                this.isShown = true;
            } else {
                this.loaderContainer.setPadding(ScarlettRecyclerAdapter.this.mLoaderPadding[0], ScarlettRecyclerAdapter.this.mLoaderPadding[1], ScarlettRecyclerAdapter.this.mLoaderPadding[2], ScarlettRecyclerAdapter.this.mLoaderPadding[3]);
                Helpers.setViewHeight((View)this.loader, ScarlettRecyclerAdapter.this.mLoaderHeight);
            }
        }

        void hideLoader() {
            if (ScarlettRecyclerAdapter.this.mAnimationEnabled) {
                final int[] initPad = new int[]{this.loaderContainer.getPaddingLeft(), this.loaderContainer.getPaddingTop(), this.loaderContainer.getPaddingRight(), this.loaderContainer.getPaddingBottom()};
                ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.loader.getHeight(), 0});
                animator.setDuration((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.setInterpolator((TimeInterpolator)ScarlettRecyclerAdapter.this.mLoaderHideInterpolator);
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        int[] pad = new int[]{0, 0, 0, 0};
                        for (int c = 0; c < ScarlettRecyclerAdapter.this.mLoaderPadding.length; ++c) {
                            pad[c] = Math.round((float)initPad[c] * (1.0f - animator.getAnimatedFraction()));
                        }
                        LoaderHolder.this.loaderContainer.setPadding(pad[0], pad[1], pad[2], pad[3]);
                        Helpers.setViewHeight((View)LoaderHolder.this.loader, (Integer)animator.getAnimatedValue());
                    }
                });
                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        LoaderHolder.this.loaderContainer.setVisibility(8);
                    }
                });
                animator.start();
                this.isShown = false;
            } else {
                this.loaderContainer.setPadding(0, 0, 0, 0);
                Helpers.setViewHeight((View)this.loader, 0);
                this.loaderContainer.setVisibility(8);
            }
        }

        boolean isShown() {
            return this.isShown;
        }

        void setBottomPadding(int padding) {
            Helpers.setViewHeight((View)this.paddingView, padding);
        }

        void setLoaderColour(int colour) {
            this.loader.getIndeterminateDrawable().setColorFilter(colour, PorterDuff.Mode.SRC_IN);
        }
    }

    private class ItemHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private View mView;
        private Object mItem;

        ItemHolder(View view) {
            super(view);
            this.mView = view;
            view.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            if (ScarlettRecyclerAdapter.this.mItemClickListener == null) {
                return;
            }
            ScarlettRecyclerAdapter.this.mItemClickListener.OnItemClick(v, this.mItem);
        }

        void setItem(Object item) {
            this.mItem = item;
        }

        Object getItem() {
            return this.mItem;
        }

        public View getView() {
            return this.mView;
        }
    }
}

