/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import net.scarlettsystems.android.widget.Helpers;
import net.scarlettsystems.android.widget.R;

class ScarlettRecyclerAdapter
extends RecyclerView.Adapter {
    private ArrayList<Object> mDataset = new ArrayList();
    private OnItemClickListener mItemClickListener = null;
    private ItemViewListener mItemViewListener = null;
    private RecyclerView mRecyclerView;
    private LoaderHolder mLoaderHolder;
    private int mDuration;
    private float mInterpFactor;
    private int mLoaderHeight = 100;
    private static final int TYPE_ITEM = 0;
    private static final int TYPE_FOOTER = -1;
    private static final int TYPE_LOADER = -2;

    public ScarlettRecyclerAdapter() {
        this.mDataset.add(new LoaderObject());
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                if (this.mItemViewListener == null) {
                    throw new IllegalStateException("OnCreateItemViewListener must be set.");
                }
                View view = this.mItemViewListener.OnCreateItemView(parent);
                if (view == null) {
                    throw new IllegalArgumentException("OnCreateItemView must return a view.");
                }
                ItemHolder holder = new ItemHolder(view);
                return holder;
            }
            case -2: {
                LoaderHolder holder;
                View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.card_loader, parent, false);
                this.mLoaderHolder = holder = new LoaderHolder(view);
                return holder;
            }
        }
        throw new IllegalArgumentException();
    }

    public void onBindViewHolder(RecyclerView.ViewHolder vh, int position) {
        if (vh instanceof ItemHolder) {
            ItemHolder h = (ItemHolder)vh;
            h.setItem(this.mDataset.get(position));
            this.mItemViewListener.OnBindItemView(h.getView(), h.getItem());
        } else if (vh instanceof LoaderHolder) {
            LoaderHolder loaderHolder = (LoaderHolder)vh;
        }
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public void setItemViewListener(ItemViewListener l) {
        this.mItemViewListener = l;
    }

    public void setAnimationDuration(int value) {
        this.mDuration = value;
    }

    public void setInterpolationFactor(float value) {
        this.mInterpFactor = value;
    }

    public void setLoaderHeight(int value) {
        this.mLoaderHeight = value;
    }

    public ArrayList<Object> getItems() {
        return this.mDataset;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mDataset.size();
    }

    public int getItemViewType(int position) {
        if (this.mDataset.get(position) instanceof LoaderObject) {
            return -2;
        }
        return 0;
    }

    public void addItem(Object item) {
        int size = this.mDataset.size();
        this.mDataset.add(size - 1, item);
        this.notifyItemInserted(this.mDataset.size() - 2);
        if (size == 1) {
            this.mRecyclerView.scrollToPosition(0);
        }
    }

    public void addItems(ArrayList<Object> items) {
        for (int c = 0; c < items.size(); ++c) {
            this.addItem(items.get(c));
        }
    }

    public void addItemAt(Object item, int index) {
        this.mDataset.add(index, item);
        this.notifyItemInserted(index);
    }

    public void removeItem(int index) {
        this.mDataset.remove(index);
        this.notifyItemRemoved(index);
    }

    public void removeAll() {
        this.mDataset.clear();
        this.notifyDataSetChanged();
    }

    public void openLoading() {
        if (this.mLoaderHolder == null) {
            return;
        }
        this.mLoaderHolder.openLoading();
    }

    public void closeLoading() {
        if (this.mLoaderHolder == null) {
            return;
        }
        this.mLoaderHolder.closeLoading();
    }

    public static interface ItemViewListener {
        public View OnCreateItemView(ViewGroup var1);

        public void OnBindItemView(View var1, Object var2);
    }

    public static interface OnItemClickListener {
        public void OnItemClick(View var1, Object var2);
    }

    private class LoaderObject {
        private LoaderObject() {
        }
    }

    private class LoaderHolder
    extends RecyclerView.ViewHolder {
        private Context mContext;
        private RelativeLayout loaderContainer;
        private RelativeLayout view;
        private boolean isOpen;

        public LoaderHolder(View itemView) {
            super(itemView);
            this.isOpen = false;
            this.mContext = itemView.getContext();
            this.view = (RelativeLayout)itemView.findViewById(R.id.padding);
            this.loaderContainer = (RelativeLayout)itemView.findViewById(R.id.loader_container);
            Helpers.setViewHeight((View)this.loaderContainer, 0);
            StaggeredGridLayoutManager.LayoutParams layoutParams = new StaggeredGridLayoutManager.LayoutParams(-1, -2);
            layoutParams.setFullSpan(true);
            itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.configureLoader();
            this.configurePadding();
        }

        private void configurePadding() {
            if (Helpers.softButtonsExist(this.mContext)) {
                Helpers.setViewHeight((View)this.view, Helpers.getNavBarHeight(this.mContext));
            } else {
                Helpers.setViewHeight((View)this.view, 0);
            }
        }

        private void configureLoader() {
            ProgressBar loader = (ProgressBar)this.loaderContainer.findViewById(R.id.loader);
        }

        public void openLoading() {
            if (!this.isOpen) {
                ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, ScarlettRecyclerAdapter.this.mLoaderHeight});
                animator.setDuration((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(ScarlettRecyclerAdapter.this.mInterpFactor));
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        Helpers.setViewHeight((View)LoaderHolder.this.loaderContainer, (Integer)valueAnimator.getAnimatedValue());
                    }
                });
                animator.start();
                this.isOpen = true;
            }
        }

        public void closeLoading() {
            if (this.isOpen) {
                int size = this.loaderContainer.getHeight();
                ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{size, 0});
                animator.setDuration((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator(ScarlettRecyclerAdapter.this.mInterpFactor));
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        Helpers.setViewHeight((View)LoaderHolder.this.loaderContainer, (Integer)valueAnimator.getAnimatedValue());
                    }
                });
                animator.start();
                this.isOpen = false;
            }
        }
    }

    private class ItemHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private View mView;
        private Object mItem;

        public ItemHolder(View view) {
            super(view);
            this.mView = view;
            view.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            if (ScarlettRecyclerAdapter.this.mItemClickListener == null) {
                return;
            }
            ScarlettRecyclerAdapter.this.mItemClickListener.OnItemClick(v, this.mItem);
        }

        public void setItem(Object item) {
            this.mItem = item;
        }

        public Object getItem() {
            return this.mItem;
        }

        public View getView() {
            return this.mView;
        }
    }
}

