/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal.plugin;

import java.io.File;
import java.util.List;
import net.roseboy.classfinal.Const;
import net.roseboy.classfinal.JarEncryptor;
import net.roseboy.classfinal.util.StrUtils;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="classFinal", defaultPhase=LifecyclePhase.PACKAGE)
public class ClassFinalPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(required=true)
    private String password;
    @Parameter
    private String code;
    @Parameter
    private String libjars;
    @Parameter
    private String packages;
    @Parameter
    private String cfgfiles;
    @Parameter
    private String excludes;
    @Parameter
    private String classpath;
    @Parameter(defaultValue="false")
    private Boolean debug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Const.DEBUG = this.debug;
        Log logger = this.getLog();
        Build build = this.project.getBuild();
        long t1 = System.currentTimeMillis();
        String targetJar = build.getDirectory() + File.separator + build.getFinalName() + "." + this.project.getPackaging();
        logger.info((CharSequence)("Encrypting " + this.project.getPackaging() + " [" + targetJar + "]"));
        List includeJarList = StrUtils.toList((String)this.libjars);
        List packageList = StrUtils.toList((String)this.packages);
        List excludeClassList = StrUtils.toList((String)this.excludes);
        List classPathList = StrUtils.toList((String)this.classpath);
        List cfgFileList = StrUtils.toList((String)this.cfgfiles);
        includeJarList.add("-");
        JarEncryptor encryptor = new JarEncryptor(targetJar, this.password.trim().toCharArray());
        encryptor.setCode(StrUtils.isEmpty((String)this.code) ? null : this.code.trim().toCharArray());
        encryptor.setPackages(packageList);
        encryptor.setIncludeJars(includeJarList);
        encryptor.setExcludeClass(excludeClassList);
        encryptor.setClassPath(classPathList);
        encryptor.setCfgfiles(cfgFileList);
        String result = encryptor.doEncryptJar();
        long t2 = System.currentTimeMillis();
        logger.info((CharSequence)("Encrypt " + encryptor.getEncryptFileCount() + " classes"));
        logger.info((CharSequence)("Encrypted " + this.project.getPackaging() + " [" + result + "]"));
        logger.info((CharSequence)"Encrypt complete");
        logger.info((CharSequence)("Time [" + (double)(t2 - t1) / 1000.0 + " s]"));
        logger.info((CharSequence)"");
    }
}

