// The MIT License (MIT)
//
// Copyright (c) 2017 PubNative GmbH
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

package net.pubnative.sdk.layouts.adapter;

import android.content.Context;

import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.api.layouts.PNAPILayout;
import net.pubnative.sdk.core.adapter.request.PubnativeLibraryCPICache;

public class PNAPI {

    private static final int DEFAULT_ASSETGROUP_SMALL  = 1;
    private static final int DEFAULT_ASSETGROUP_MEDIUM = 5;
    private static final int DEFAULT_ASSETGROUP_LARGE  = 16;

    private static int getDefaultAssetGroup(PNAPILayout.Size size) {

        int result = 0;
        switch (size) {
            case LARGE:
                result = DEFAULT_ASSETGROUP_LARGE;
                break;
            case MEDIUM:
                result = DEFAULT_ASSETGROUP_MEDIUM;
                break;
            case SMALL:
                result = DEFAULT_ASSETGROUP_SMALL;
                break;
        }
        return result;
    }

    public static PNAPIAdModel filterAd(Context context, PNAPIAdModel model, boolean isCPICacheEnabled, PNAPILayout.Size size) {
        PNAPIAdModel result = model;
        if (isCPICacheEnabled && (result == null || result.isRevenueModelCPA())) {
            PNAPIAdModel newAd = PubnativeLibraryCPICache.get(context);
            if (newAd != null) {
                newAd.setAssetGroupId(getDefaultAssetGroup(size));
                result = newAd;
            }
        }
        return result;
    }
}
