package net.pubnative.api.core.view;

import android.content.Context;
import android.graphics.PixelFormat;
import android.util.Log;
import android.view.WindowManager;

public class PNAPILoadingViewManager {
    protected static final String TAG = PNAPILoadingViewManager.class.getSimpleName();

    protected Context mContext;
    protected WindowManager mWindowManager;
    protected PNAPILoadingView mLoadingView;

    protected boolean isDisplayed;

    public PNAPILoadingViewManager(Context context) {
        this.mContext = context;
        this.mWindowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        this.mLoadingView = new PNAPILoadingView(mContext);
        this.isDisplayed = false;
    }

    protected WindowManager.LayoutParams getWindowManagerParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.width = WindowManager.LayoutParams.MATCH_PARENT;
        params.height = WindowManager.LayoutParams.MATCH_PARENT;
        params.flags = WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH | WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;
        params.format = PixelFormat.TRANSLUCENT;

        return params;
    }

    public void show() {
        if (isDisplayed) {
            Log.i(TAG, "Loader is already showing. Dropping call");
        } else {
            mWindowManager.addView(mLoadingView, getWindowManagerParams());
            isDisplayed = true;
        }
    }

    public void hide() {
        if (isDisplayed) {
            mWindowManager.removeView(mLoadingView);
            isDisplayed = false;
        } else {
            Log.i(TAG, "Loader is not showing. Dropping call");
        }
    }
}
