/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts.adapter;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import java.util.Map;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.core.insights.model.PNInsightModel;

public abstract class PNLayoutAdapter {
    private static final String TAG = PNLayoutAdapter.class.getSimpleName();
    protected static final String DEFAULT_ERROR = "unknown";
    protected Context mContext;
    protected PubnativeNetworkAdapterRunnable mTimeoutRunnable;
    protected LoadListener mLoadListener;
    protected TrackListener mTrackListener;
    protected Map<String, String> mNetworkData;
    protected Handler mHandler;
    protected PNInsightModel mInsight;
    protected boolean mIsCPICacheEnabled;
    protected long mRequestStartTimeStamp;

    public void setLoadListener(LoadListener loadListener) {
        this.mLoadListener = loadListener;
    }

    public void setTrackListener(TrackListener trackListener) {
        this.mTrackListener = trackListener;
    }

    public void setInsight(PNInsightModel pNInsightModel) {
        this.mInsight = pNInsightModel;
    }

    public void setNetworkData(Map<String, String> map) {
        this.mNetworkData = map;
    }

    public void setCPICacheEnabled(boolean bl) {
        this.mIsCPICacheEnabled = bl;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.mRequestStartTimeStamp;
    }

    protected void invokeLoadSuccess() {
        this.cancelTimeout();
        LoadListener loadListener = this.mLoadListener;
        this.mLoadListener = null;
        if (loadListener != null) {
            loadListener.onAdapterLoadFinished(this);
        }
    }

    protected void invokeLoadFail(Exception exception) {
        this.cancelTimeout();
        LoadListener loadListener = this.mLoadListener;
        this.mLoadListener = null;
        if (loadListener != null) {
            loadListener.onAdapterLoadFail(this, exception);
        }
    }

    protected void invokeImpression() {
        if (this.mTrackListener != null) {
            this.mTrackListener.onAdapterTrackImpression();
        }
    }

    protected void invokeClick() {
        if (this.mTrackListener != null) {
            this.mTrackListener.onAdapterTrackClick();
        }
    }

    public void execute(Context context, int n) {
        this.mContext = context;
        this.mRequestStartTimeStamp = System.currentTimeMillis();
        this.startTimeout(n);
        this.request(context, this.mNetworkData);
    }

    protected void startTimeout(int n) {
        if (n > 0) {
            this.mTimeoutRunnable = new PubnativeNetworkAdapterRunnable();
            this.mHandler = new Handler(Looper.getMainLooper());
            this.mHandler.postDelayed((Runnable)this.mTimeoutRunnable, (long)n);
        }
    }

    protected void cancelTimeout() {
        if (this.mHandler != null && this.mTimeoutRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mTimeoutRunnable);
            this.mHandler = null;
        }
    }

    protected void onTimeout() {
        this.invokeLoadFail(PNException.ADAPTER_TIMEOUT);
    }

    protected abstract void request(Context var1, Map<String, String> var2);

    public static interface TrackListener {
        public void onAdapterTrackImpression();

        public void onAdapterTrackClick();
    }

    public static interface LoadListener {
        public void onAdapterLoadFinished(PNLayoutAdapter var1);

        public void onAdapterLoadFail(PNLayoutAdapter var1, Exception var2);
    }

    protected class PubnativeNetworkAdapterRunnable
    implements Runnable {
        private final String TAG = this.getClass().getSimpleName();

        protected PubnativeNetworkAdapterRunnable() {
        }

        @Override
        public void run() {
            PNLayoutAdapter.this.onTimeout();
        }
    }
}

