/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts;

import android.content.Context;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;
import net.pubnative.sdk.core.PNSettings;
import net.pubnative.sdk.core.config.PNPlacement;
import net.pubnative.sdk.core.config.model.PNNetworkModel;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.core.insights.model.PNInsightDataModel;
import net.pubnative.sdk.core.insights.model.PNInsightModel;
import net.pubnative.sdk.core.utils.PNDeviceUtils;

public abstract class PNLayoutWaterfall {
    private static String TAG = PNLayoutWaterfall.class.getSimpleName();
    protected static final String TRACKING_PARAMETER_APP_TOKEN = "app_token";
    protected static final String TRACKING_PARAMETER_REQUEST_ID = "reqid";
    protected Context mContext;
    protected String mAppToken;
    protected PNPlacement mPlacement;
    protected PNInsightModel mInsight;

    public void setInsight(PNInsightModel pNInsightModel) {
        this.mInsight = pNInsightModel;
    }

    protected synchronized void initialize(Context context, String string, String string2) {
        if (context == null || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            this.onPubnativeNetworkLayoutWaterfallLoadFail(PNException.REQUEST_PARAMETERS_INVALID);
        } else if (PNDeviceUtils.isNetworkAvailable(context)) {
            this.mContext = context;
            this.mAppToken = string;
            this.mPlacement = new PNPlacement();
            HashMap hashMap = new HashMap();
            this.mPlacement.load(this.mContext, string, string2, hashMap, new PNPlacement.Listener(){

                @Override
                public void onPlacementReady(PNPlacement pNPlacement, boolean bl) {
                    if (bl) {
                        PNLayoutWaterfall.this.onPubnativeNetworkLayoutWaterfallLoadFinish(bl);
                    } else {
                        PNLayoutWaterfall.this.startTracking();
                    }
                }

                @Override
                public void onPlacementLoadFail(PNPlacement pNPlacement, Exception exception) {
                    PNLayoutWaterfall.this.onPubnativeNetworkLayoutWaterfallLoadFail(exception);
                }
            });
        } else {
            this.onPubnativeNetworkLayoutWaterfallLoadFail(PNException.REQUEST_NO_INTERNET);
        }
    }

    protected void startTracking() {
        if (PNSettings.isCoppaModeEnabled) {
            this.startTracking(null);
        } else {
            this.startTracking(PNSettings.advertisingId);
        }
    }

    protected void startTracking(String string) {
        String string2 = (String)this.mPlacement.getConfig().getGlobal("request_beacon");
        String string3 = (String)this.mPlacement.getConfig().getGlobal("impression_beacon");
        String string4 = (String)this.mPlacement.getConfig().getGlobal("click_beacon");
        String string5 = (String)this.mPlacement.getConfig().getGlobal("recovered_network_url");
        this.mInsight = new PNInsightModel(this.mContext);
        this.mInsight.setInsightURLs(string2, string3, string4, string5);
        this.mInsight.addExtra(TRACKING_PARAMETER_APP_TOKEN, this.mPlacement.getAppToken());
        this.mInsight.addExtra(TRACKING_PARAMETER_REQUEST_ID, this.mPlacement.getTrackingUUID());
        this.mInsight.addExtras(this.mPlacement.getConfig().request_params);
        PNInsightDataModel pNInsightDataModel = this.mInsight.getData();
        pNInsightDataModel.placement_name = this.mPlacement.getName();
        pNInsightDataModel.delivery_segment_ids = this.mPlacement.getDeliveryRule().segment_ids;
        pNInsightDataModel.ad_format_code = this.mPlacement.getAdFormatCode();
        pNInsightDataModel.coppa = PNSettings.isCoppaModeEnabled ? "1" : "0";
        pNInsightDataModel.user_uid = string;
        this.mInsight.setData(pNInsightDataModel);
        this.onPubnativeNetworkLayoutWaterfallLoadFinish(false);
    }

    protected void getNextNetwork() {
        this.mPlacement.next();
        PNNetworkModel pNNetworkModel = this.mPlacement.getCurrentNetwork();
        if (pNNetworkModel == null) {
            this.sendRequestInsight();
            this.onPubnativeNetworkLayoutWaterfallLoadFail(PNException.REQUEST_NO_FILL);
        } else {
            this.onPubnativeNetworkLayoutWaterfallNextNetwork(this.getHubExtras());
        }
    }

    protected Map<String, String> getHubExtras() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TRACKING_PARAMETER_REQUEST_ID, this.mPlacement.getTrackingUUID());
        return hashMap;
    }

    protected synchronized void trackSuccededNetwork(long l) {
        this.mInsight.trackSuccededNetwork(this.mPlacement.getCurrentPriority(), l);
        this.sendRequestInsight();
    }

    protected void sendRequestInsight() {
        this.mInsight.sendRequestInsight(null);
    }

    protected void trackAttemptedNetwork(long l, Exception exception) {
        Exception exception2 = null;
        if (this.mPlacement.getCurrentNetwork().isCrashReportEnabled()) {
            exception2 = exception;
        }
        this.mInsight.trackAttemptedNetwork(this.mPlacement.getCurrentPriority(), l, exception2);
    }

    protected void trackUnreachableNetwork(long l, Exception exception) {
        Exception exception2 = null;
        if (this.mPlacement.getCurrentNetwork().isCrashReportEnabled()) {
            exception2 = exception;
        }
        this.mInsight.trackUnreachableNetwork(this.mPlacement.getCurrentPriority(), l, exception2);
    }

    protected abstract void onPubnativeNetworkLayoutWaterfallLoadFinish(boolean var1);

    protected abstract void onPubnativeNetworkLayoutWaterfallLoadFail(Exception var1);

    protected abstract void onPubnativeNetworkLayoutWaterfallNextNetwork(Map var1);
}

