/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.config;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class PNDeliveryManager {
    private static String TAG = PNDeliveryManager.class.getSimpleName();
    protected static final String IMPRESSION_PREFERENCES_KEY = "net.pubnative.mediation.frequency_manager";
    protected static final String IMPRESSION_COUNT_DAY_APPEND = "_impression_count_day";
    protected static final String IMPRESSION_COUNT_HOUR_APPEND = "_impression_count_hour";
    protected static final String IMPRESSION_LAST_UPDATE_APPEND = "_impression_last_update";
    protected Map<String, Calendar> mCurrentPacing = new HashMap<String, Calendar>();
    protected static PNDeliveryManager sInstance = null;

    private PNDeliveryManager() {
    }

    protected static synchronized PNDeliveryManager getInstance() {
        if (sInstance == null) {
            sInstance = new PNDeliveryManager();
        }
        return sInstance;
    }

    public static Calendar getPacingCalendar(String string) {
        Calendar calendar = null;
        if (PNDeliveryManager.getInstance().mCurrentPacing.containsKey(string)) {
            calendar = PNDeliveryManager.getInstance().mCurrentPacing.get(string);
        }
        return calendar;
    }

    public static void updatePacingCalendar(String string) {
        PNDeliveryManager.getInstance().mCurrentPacing.put(string, Calendar.getInstance());
    }

    public static void resetPacingCalendar(String string) {
        PNDeliveryManager.getInstance().mCurrentPacing.put(string, null);
    }

    public static void logImpression(Context context, String string) {
        int n = PNDeliveryManager.getImpressionCount(context, IMPRESSION_COUNT_DAY_APPEND, string);
        int n2 = PNDeliveryManager.getImpressionCount(context, IMPRESSION_COUNT_HOUR_APPEND, string);
        PNDeliveryManager.setImpressionCount(context, IMPRESSION_COUNT_DAY_APPEND, string, ++n);
        PNDeliveryManager.setImpressionCount(context, IMPRESSION_COUNT_HOUR_APPEND, string, ++n2);
    }

    public static void resetDailyImpressionCount(Context context, String string) {
        PNDeliveryManager.setImpressionCount(context, IMPRESSION_COUNT_DAY_APPEND, string, 0);
    }

    public static void resetHourlyImpressionCount(Context context, String string) {
        PNDeliveryManager.setImpressionCount(context, IMPRESSION_COUNT_HOUR_APPEND, string, 0);
    }

    public static int getCurrentDailyCount(Context context, String string) {
        return PNDeliveryManager.getImpressionCount(context, IMPRESSION_COUNT_DAY_APPEND, string);
    }

    public static int getCurrentHourlyCount(Context context, String string) {
        return PNDeliveryManager.getImpressionCount(context, IMPRESSION_COUNT_HOUR_APPEND, string);
    }

    public static void setImpressionLastUpdate(Context context, String string, Calendar calendar) {
        SharedPreferences.Editor editor;
        if (context != null && !TextUtils.isEmpty((CharSequence)string) && (editor = PNDeliveryManager.getPreferencesEditor(context)) != null) {
            String string2 = string.concat(IMPRESSION_LAST_UPDATE_APPEND);
            if (calendar == null) {
                editor.remove(string2);
            } else {
                editor.putLong(string2, calendar.getTimeInMillis());
            }
            editor.apply();
        }
    }

    public static Calendar getImpressionLastUpdate(Context context, String string) {
        String string2;
        long l;
        SharedPreferences sharedPreferences;
        Calendar calendar = null;
        if (context != null && !TextUtils.isEmpty((CharSequence)string) && (sharedPreferences = PNDeliveryManager.getPreferences(context)) != null && (l = sharedPreferences.getLong(string2 = string.concat(IMPRESSION_LAST_UPDATE_APPEND), 0L)) > 0L) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
        }
        return calendar;
    }

    protected static void updateImpressionCount(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            Calendar calendar = PNDeliveryManager.getImpressionLastUpdate(context, string);
            if (calendar != null) {
                Calendar calendar2 = Calendar.getInstance();
                calendar2.set(11, 0);
                calendar2.set(12, 0);
                calendar2.set(13, 0);
                calendar2.set(14, 0);
                if (calendar.before(calendar2)) {
                    PNDeliveryManager.setImpressionCount(context, IMPRESSION_COUNT_DAY_APPEND, string, 0);
                }
                Calendar calendar3 = Calendar.getInstance();
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
                if (calendar.before(calendar3)) {
                    PNDeliveryManager.setImpressionCount(context, IMPRESSION_COUNT_HOUR_APPEND, string, 0);
                }
            }
            PNDeliveryManager.setImpressionLastUpdate(context, string, Calendar.getInstance());
        }
    }

    protected static void setImpressionCount(Context context, String string, String string2, int n) {
        SharedPreferences.Editor editor;
        if (context != null && !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) && (editor = PNDeliveryManager.getPreferencesEditor(context)) != null) {
            String string3 = string2.concat(string);
            if (n == 0) {
                editor.remove(string3);
            } else {
                editor.putInt(string3, n);
            }
            editor.apply();
        }
    }

    protected static int getImpressionCount(Context context, String string, String string2) {
        SharedPreferences sharedPreferences;
        PNDeliveryManager.updateImpressionCount(context, string2);
        int n = 0;
        if (context != null && !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) && (sharedPreferences = PNDeliveryManager.getPreferences(context)) != null) {
            String string3 = string2.concat(string);
            n = sharedPreferences.getInt(string3, 0);
        }
        return n;
    }

    protected static SharedPreferences.Editor getPreferencesEditor(Context context) {
        SharedPreferences.Editor editor = null;
        if (context != null) {
            editor = PNDeliveryManager.getPreferences(context).edit();
        }
        return editor;
    }

    protected static SharedPreferences getPreferences(Context context) {
        SharedPreferences sharedPreferences = null;
        if (context != null) {
            sharedPreferences = context.getSharedPreferences(IMPRESSION_PREFERENCES_KEY, 0);
        }
        return sharedPreferences;
    }
}

