/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;

public class PNAPIImageDownloader {
    private static final String TAG = PNAPIImageDownloader.class.getSimpleName();
    private WeakReference<Bitmap> mImage;
    private Listener mListener;
    private Handler mHandler;

    public void load(String string, Listener listener) {
        Log.v((String)TAG, (String)"load");
        this.mHandler = new Handler(Looper.getMainLooper());
        if (listener == null) {
            Log.e((String)TAG, (String)"Listener is not set, dropping call");
        } else if (TextUtils.isEmpty((CharSequence)string)) {
            this.invokeFail(string, new Exception("URL is not valid"));
        } else {
            this.mListener = listener;
            this.downloadImage(string);
        }
    }

    private void downloadImage(final String string) {
        Log.v((String)TAG, (String)"downloadImage");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    URL uRL = new URL(string);
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeStream((InputStream)uRL.openConnection().getInputStream(), (Rect)new Rect(), (BitmapFactory.Options)options);
                    int n = 0;
                    n = PNAPIImageDownloader.this.calculateInSampleSize(options);
                    if (n == 0) {
                        PNAPIImageDownloader.this.invokeFail(string, new Exception("Not enough memory"));
                    } else {
                        options.inSampleSize = n;
                        options.inJustDecodeBounds = false;
                        PNAPIImageDownloader.this.mImage = new WeakReference<Bitmap>(BitmapFactory.decodeStream((InputStream)uRL.openConnection().getInputStream(), null, (BitmapFactory.Options)options));
                        PNAPIImageDownloader.this.invokeLoad(string);
                    }
                }
                catch (Exception exception) {
                    PNAPIImageDownloader.this.invokeFail(string, exception);
                }
                catch (Error error) {
                    PNAPIImageDownloader.this.mImage = null;
                    PNAPIImageDownloader.this.invokeFail(string, new Exception("Out of memory during image downloading"));
                }
            }
        }).start();
    }

    protected void invokeLoad(final String string) {
        Log.v((String)TAG, (String)"invokeLoad");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PNAPIImageDownloader.this.mListener != null) {
                    if (PNAPIImageDownloader.this.mImage == null || PNAPIImageDownloader.this.mImage.get() == null) {
                        PNAPIImageDownloader.this.mListener.onImageFailed(string, new Exception("Error: image gor released"));
                    } else {
                        PNAPIImageDownloader.this.mListener.onImageLoad(string, (Bitmap)PNAPIImageDownloader.this.mImage.get());
                    }
                }
            }
        });
    }

    protected void invokeFail(final String string, final Exception exception) {
        Log.v((String)TAG, (String)"invokeFail");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PNAPIImageDownloader.this.mListener != null) {
                    PNAPIImageDownloader.this.mListener.onImageFailed(string, exception);
                }
            }
        });
    }

    protected int calculateInSampleSize(BitmapFactory.Options options) {
        Log.v((String)TAG, (String)"calculateInSampleSize");
        int n = 1;
        int n2 = (int)Runtime.getRuntime().freeMemory();
        int n3 = 4;
        int n4 = options.outWidth * options.outHeight * n3;
        if (n2 == 0) {
            n = 0;
        } else if (n4 > n2 && n2 > 0) {
            n = n4 / n2;
        }
        return n;
    }

    public static interface Listener {
        public void onImageLoad(String var1, Bitmap var2);

        public void onImageFailed(String var1, Exception var2);
    }
}

