/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts;

import android.util.Log;
import java.util.Map;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.layouts.PNLayout;
import net.pubnative.sdk.layouts.adapter.PNLayoutAdapter;
import net.pubnative.sdk.layouts.adapter.PNLayoutFullscreenAdapter;
import net.pubnative.sdk.layouts.adapter.large.PNLargeLayoutAdapterFactory;

public class PNLargeLayout
extends PNLayout
implements PNLayoutAdapter.LoadListener,
PNLayoutAdapter.TrackListener,
PNLayoutFullscreenAdapter.ViewListener {
    private static final String TAG = PNLargeLayout.class.getSimpleName();
    protected ViewListener mViewListener;
    protected PNLayoutFullscreenAdapter mAdapter;
    protected boolean isShown;

    public void setViewListener(ViewListener viewListener) {
        this.mViewListener = viewListener;
    }

    public boolean isReady() {
        return this.mAdapter != null;
    }

    public void show() {
        if (this.isReady()) {
            this.mAdapter.setViewListener(this);
            this.mAdapter.setTrackListener(this);
            this.mAdapter.show();
        } else {
            Log.w((String)TAG, (String)"This layout is not loaded, did you forgot to load it before?");
        }
    }

    public void hide() {
        if (this.isReady() && this.isShown) {
            this.mAdapter.hide();
            this.mAdapter.setViewListener(null);
            this.mAdapter.setTrackListener(null);
        } else {
            Log.w((String)TAG, (String)"This layout is not loaded or shown, did you forgot to load or show it before?");
        }
    }

    @Override
    public void onAdapterLoadFinished(PNLayoutAdapter pNLayoutAdapter) {
        this.trackSuccededNetwork(pNLayoutAdapter.getElapsedTime());
        this.mAdapter = (PNLayoutFullscreenAdapter)pNLayoutAdapter;
        this.invokeFinish();
    }

    @Override
    public void onAdapterLoadFail(PNLayoutAdapter pNLayoutAdapter, Exception exception) {
        if (exception.getClass().isAssignableFrom(PNException.class)) {
            this.trackUnreachableNetwork(pNLayoutAdapter.getElapsedTime(), exception);
        } else {
            this.trackAttemptedNetwork(pNLayoutAdapter.getElapsedTime(), exception);
        }
        this.getNextNetwork();
    }

    @Override
    public void onAdapterTrackImpression() {
        this.invokeImpression();
    }

    @Override
    public void onAdapterTrackClick() {
        this.invokeClick();
    }

    @Override
    public void onAdapterViewShow() {
        this.invokeShow();
    }

    @Override
    public void onAdapterViewHide() {
        this.invokeHide();
    }

    protected void invokeShow() {
        this.isShown = true;
        if (this.mViewListener != null) {
            this.mViewListener.onPNLayoutViewShown(this);
        }
    }

    protected void invokeHide() {
        this.isShown = false;
        if (this.mViewListener != null) {
            this.mViewListener.onPNLayoutViewHidden(this);
        }
    }

    @Override
    protected void onPubnativeNetworkLayoutWaterfallLoadFinish(boolean bl) {
        if (bl && this.mAdapter == null) {
            this.invokeFail(PNException.PLACEMENT_PACING_CAP);
        } else if (bl) {
            this.invokeFinish();
        } else {
            this.getNextNetwork();
        }
    }

    @Override
    protected void onPubnativeNetworkLayoutWaterfallLoadFail(Exception exception) {
        this.invokeFail(exception);
    }

    @Override
    protected void onPubnativeNetworkLayoutWaterfallNextNetwork(Map map) {
        PNLayoutAdapter pNLayoutAdapter = PNLargeLayoutAdapterFactory.getAdapter(this.mPlacement.getCurrentNetwork());
        if (pNLayoutAdapter == null) {
            this.trackUnreachableNetwork(0L, PNException.ADAPTER_TYPE_NOT_IMPLEMENTED);
            this.getNextNetwork();
        } else {
            pNLayoutAdapter.setCPICacheEnabled(this.mPlacement.getCurrentNetwork().isCPACacheEnabled());
            pNLayoutAdapter.setInsight(this.mInsight);
            pNLayoutAdapter.setLoadListener(this);
            pNLayoutAdapter.execute(this.mContext, this.mPlacement.getCurrentNetwork().getTimeout());
        }
    }

    public static interface ViewListener {
        public void onPNLayoutViewShown(PNLayout var1);

        public void onPNLayoutViewHidden(PNLayout var1);
    }
}

