/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.layouts;

import android.content.Context;
import android.util.Log;
import java.util.List;
import net.pubnative.api.core.request.PNAPIRequest;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.api.layouts.PNAPILayoutView;
import net.pubnative.api.layouts.asset_group.PNAPIAssetGroup;
import net.pubnative.api.layouts.asset_group.PNAPIAssetGroupFactory;

public class PNAPILayout
extends PNAPIRequest
implements PNAPIRequest.Listener {
    private static final String TAG = PNAPILayout.class.getSimpleName();
    protected LoadListener mLoadListener;
    protected FetchListener mFetchListener;
    protected PNAPIAdModel mAdModel;
    protected Size mSize;

    public void load(Context context, Size size, LoadListener loadListener) {
        if (loadListener == null) {
            Log.e((String)TAG, (String)"Listener is required and null, dropping this call");
        } else if (size == null) {
            Log.e((String)TAG, (String)"Size is required and null, please specify the size, dropping this call");
        } else {
            this.mSize = size;
            this.mLoadListener = loadListener;
            this.setParameter("al", size.toString());
            super.start(context, this);
        }
    }

    public void fetch(FetchListener fetchListener) {
        if (fetchListener == null) {
            Log.e((String)TAG, (String)"Listener is required and null, dropping this call");
        } else {
            this.mFetchListener = fetchListener;
            PNAPIAssetGroup pNAPIAssetGroup = PNAPIAssetGroupFactory.createView(this.mContext, this.mAdModel);
            if (pNAPIAssetGroup == null) {
                this.invokeFail(new Exception("Error: could not initialise asset group view"));
            } else {
                pNAPIAssetGroup.setLoadListener(new PNAPIAssetGroup.LoadListener(){

                    @Override
                    public void onPubnativeAssetGroupLoadFinish(PNAPIAssetGroup pNAPIAssetGroup) {
                        PNAPILayout.this.invokeFetchFinish(pNAPIAssetGroup);
                    }

                    @Override
                    public void onPubnativeAssetGroupLoadFail(PNAPIAssetGroup pNAPIAssetGroup, Exception exception) {
                        PNAPILayout.this.invokeFetchFail(exception);
                    }
                });
                pNAPIAssetGroup.load();
            }
        }
    }

    public void setAdModel(PNAPIAdModel pNAPIAdModel) {
        this.mAdModel = pNAPIAdModel;
    }

    protected void invokeLoadFinish() {
        if (this.mLoadListener != null) {
            this.mLoadListener.onPubnativeLayoutLoadFinish(this, this.mAdModel);
        }
    }

    protected void invokeFail(Exception exception) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onPubnativeLayoutLoadFail(this, exception);
        }
    }

    protected void invokeFetchFinish(PNAPILayoutView pNAPILayoutView) {
        if (this.mFetchListener != null) {
            this.mFetchListener.onPubnativeLayoutFetchFinish(this, pNAPILayoutView);
        }
    }

    protected void invokeFetchFail(Exception exception) {
        if (this.mFetchListener != null) {
            this.mFetchListener.onPubnativeLayoutFetchFail(this, exception);
        }
    }

    @Override
    public void onPNAPIRequestFinish(PNAPIRequest pNAPIRequest, List<PNAPIAdModel> list) {
        if (list == null || list.size() == 0) {
            this.invokeFail(new Exception("No fill, pubnative did not return any valid ad"));
        } else {
            this.mAdModel = list.get(0);
            this.invokeLoadFinish();
        }
    }

    @Override
    public void onPNAPIRequestFail(PNAPIRequest pNAPIRequest, Exception exception) {
        this.invokeFail(exception);
    }

    public static enum Size {
        SMALL("s"),
        MEDIUM("m"),
        LARGE("l");

        private final String size;

        private Size(String string2) {
            this.size = string2;
        }

        public String toString() {
            return this.size;
        }
    }

    public static interface FetchListener {
        public void onPubnativeLayoutFetchFinish(PNAPILayout var1, PNAPILayoutView var2);

        public void onPubnativeLayoutFetchFail(PNAPILayout var1, Exception var2);
    }

    public static interface LoadListener {
        public void onPubnativeLayoutLoadFinish(PNAPILayout var1, PNAPIAdModel var2);

        public void onPubnativeLayoutLoadFail(PNAPILayout var1, Exception var2);
    }
}

