/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.tracking;

import android.graphics.Rect;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class PNAPIVisibilityTracker {
    private static final String TAG = PNAPIVisibilityTracker.class.getSimpleName();
    private static final int VISIBILITY_CHECK_DELAY = 100;
    protected WeakReference<View> mDeviceView = null;
    protected WeakReference<Listener> mListener = null;
    protected List<PubnativeVisibilityTrackerItem> mTrackedViews = new ArrayList<PubnativeVisibilityTrackerItem>();
    protected Handler mHandler = new Handler();
    protected boolean mIsVisibilityCheckScheduled = false;
    protected VisibilityRunnable mVisibilityRunnable = new VisibilityRunnable();
    protected ViewTreeObserver.OnPreDrawListener mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            if (PNAPIVisibilityTracker.this.mListener == null || PNAPIVisibilityTracker.this.mListener.get() == null) {
                PNAPIVisibilityTracker.this.clear();
            } else {
                PNAPIVisibilityTracker.this.scheduleVisibilityCheck();
            }
            return true;
        }
    };

    public void setListener(Listener listener) {
        this.mListener = new WeakReference<Listener>(listener);
    }

    public void addView(View view, double d) {
        Object object;
        if (this.mDeviceView == null) {
            this.mDeviceView = new WeakReference<View>(view);
            object = view.getViewTreeObserver();
            if (object.isAlive()) {
                object.addOnPreDrawListener(this.mOnPreDrawListener);
            } else {
                Log.d((String)TAG, (String)"Unable to start tracking, Window ViewTreeObserver is not alive");
            }
        }
        if (this.containsTrackedView(view)) {
            return;
        }
        object = new PubnativeVisibilityTrackerItem();
        object.mTrackingView = view;
        object.mMinVisibilityPercent = d;
        this.mTrackedViews.add((PubnativeVisibilityTrackerItem)object);
        this.scheduleVisibilityCheck();
    }

    public void removeView(View view) {
        this.mTrackedViews.remove(view);
    }

    public void clear() {
        View view;
        this.mHandler.removeMessages(0);
        this.mTrackedViews.clear();
        this.mIsVisibilityCheckScheduled = false;
        if (this.mDeviceView != null && (view = (View)this.mDeviceView.get()) != null && this.mOnPreDrawListener != null) {
            ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnPreDrawListener(this.mOnPreDrawListener);
            }
            this.mOnPreDrawListener = null;
        }
        this.mListener = null;
    }

    protected void scheduleVisibilityCheck() {
        if (!this.mIsVisibilityCheckScheduled) {
            this.mIsVisibilityCheckScheduled = true;
            this.mHandler.postDelayed((Runnable)this.mVisibilityRunnable, 100L);
        }
    }

    protected boolean containsTrackedView(View view) {
        return this.indexOfTrackedView(view) >= 0;
    }

    protected int indexOfTrackedView(View view) {
        int n = -1;
        for (int i = 0; i < this.mTrackedViews.size(); ++i) {
            PubnativeVisibilityTrackerItem pubnativeVisibilityTrackerItem = this.mTrackedViews.get(i);
            if (!pubnativeVisibilityTrackerItem.equals(view)) continue;
            n = i;
            break;
        }
        return n;
    }

    protected class VisibilityRunnable
    implements Runnable {
        private ArrayList<View> mVisibleViews;
        private ArrayList<View> mInvisibleViews;
        private Rect mVisibleRect = new Rect();

        VisibilityRunnable() {
            this.mInvisibleViews = new ArrayList();
            this.mVisibleViews = new ArrayList();
        }

        @Override
        public void run() {
            PNAPIVisibilityTracker.this.mIsVisibilityCheckScheduled = false;
            for (PubnativeVisibilityTrackerItem pubnativeVisibilityTrackerItem : PNAPIVisibilityTracker.this.mTrackedViews) {
                if (this.isVisible(pubnativeVisibilityTrackerItem)) {
                    this.mVisibleViews.add(pubnativeVisibilityTrackerItem.mTrackingView);
                    continue;
                }
                this.mInvisibleViews.add(pubnativeVisibilityTrackerItem.mTrackingView);
            }
            if (PNAPIVisibilityTracker.this.mListener != null && PNAPIVisibilityTracker.this.mListener.get() != null) {
                ((Listener)PNAPIVisibilityTracker.this.mListener.get()).onVisibilityCheck(this.mVisibleViews, this.mInvisibleViews);
            }
            this.mInvisibleViews.clear();
            this.mVisibleViews.clear();
        }

        protected boolean isVisible(PubnativeVisibilityTrackerItem pubnativeVisibilityTrackerItem) {
            boolean bl = false;
            View view = pubnativeVisibilityTrackerItem.mTrackingView;
            if (view != null && view.isShown() && view.getParent() != null && view.getLocalVisibleRect(this.mVisibleRect)) {
                float f;
                float f2 = this.mVisibleRect.height() * this.mVisibleRect.width();
                double d = (double)f2 / (double)(f = (float)(view.getHeight() * view.getWidth()));
                bl = d >= pubnativeVisibilityTrackerItem.mMinVisibilityPercent;
            }
            return bl;
        }
    }

    protected class PubnativeVisibilityTrackerItem {
        private final String TAG = PubnativeVisibilityTrackerItem.class.getSimpleName();
        public View mTrackingView;
        public double mMinVisibilityPercent;

        protected PubnativeVisibilityTrackerItem() {
        }

        public boolean equals(Object object) {
            if (object instanceof View) {
                return object.equals(this.mTrackingView);
            }
            return super.equals(object);
        }
    }

    public static interface Listener {
        public void onVisibilityCheck(List<View> var1, List<View> var2);
    }
}

